/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergFileWriter;
import io.trino.plugin.iceberg.IcebergFileWriterFactory;
import io.trino.plugin.iceberg.MetricsWrapper;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.LocationProvider;
import org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;

public class PositionDeleteWriter {
    private final String dataFilePath;
    private final Block dataFilePathBlock;
    private final PartitionSpec partitionSpec;
    private final Optional<PartitionData> partition;
    private final String outputPath;
    private final JsonCodec<CommitTaskData> jsonCodec;
    private final IcebergFileWriter writer;
    private final IcebergFileFormat fileFormat;

    public PositionDeleteWriter(String dataFilePath, PartitionSpec partitionSpec, Optional<PartitionData> partition, LocationProvider locationProvider, IcebergFileWriterFactory fileWriterFactory, TrinoFileSystem fileSystem, JsonCodec<CommitTaskData> jsonCodec, ConnectorSession session, IcebergFileFormat fileFormat, Map<String, String> storageProperties) {
        this.dataFilePath = Objects.requireNonNull(dataFilePath, "dataFilePath is null");
        this.dataFilePathBlock = Utils.nativeValueToBlock((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)dataFilePath));
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
        this.partitionSpec = Objects.requireNonNull(partitionSpec, "partitionSpec is null");
        this.partition = Objects.requireNonNull(partition, "partition is null");
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        String fileName = fileFormat.toIceberg().addExtension(session.getQueryId() + "-" + String.valueOf(UUID.randomUUID()));
        this.outputPath = partition.map(partitionData -> locationProvider.newDataLocation(partitionSpec, (StructLike)partitionData, fileName)).orElseGet(() -> locationProvider.newDataLocation(fileName));
        this.writer = fileWriterFactory.createPositionDeleteWriter(fileSystem, Location.of((String)this.outputPath), session, fileFormat, storageProperties);
    }

    public Collection<Slice> write(ImmutableLongBitmapDataProvider rowsToDelete) {
        this.writeDeletes(rowsToDelete);
        this.writer.commit();
        CommitTaskData task = new CommitTaskData(this.outputPath, this.fileFormat, this.writer.getWrittenBytes(), new MetricsWrapper(this.writer.getFileMetrics().metrics()), PartitionSpecParser.toJson((PartitionSpec)this.partitionSpec), this.partition.map(PartitionData::toJson), FileContent.POSITION_DELETES, Optional.of(this.dataFilePath), this.writer.getFileMetrics().splitOffsets());
        return List.of(Slices.wrappedBuffer((byte[])this.jsonCodec.toJsonBytes((Object)task)));
    }

    public void abort() {
        this.writer.rollback();
    }

    private void writeDeletes(ImmutableLongBitmapDataProvider rowsToDelete) {
        PageBuilder pageBuilder = new PageBuilder(List.of(BigintType.BIGINT));
        rowsToDelete.forEach(rowPosition -> {
            pageBuilder.declarePosition();
            BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(0), rowPosition);
            if (pageBuilder.isFull()) {
                this.writePage(pageBuilder.build());
                pageBuilder.reset();
            }
        });
        if (!pageBuilder.isEmpty()) {
            this.writePage(pageBuilder.build());
        }
    }

    private void writePage(Page page) {
        this.writer.appendRows(new Page(new Block[]{RunLengthEncodedBlock.create((Block)this.dataFilePathBlock, (int)page.getPositionCount()), page.getBlock(0)}));
    }
}

