/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.functions.tablechanges;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorTableFunction;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesFunction;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.type.TypeManager;
import java.util.Objects;

public class TableChangesFunctionProvider
implements Provider<ConnectorTableFunction> {
    private final TrinoCatalogFactory trinoCatalogFactory;
    private final TypeManager typeManager;

    @Inject
    public TableChangesFunctionProvider(TrinoCatalogFactory trinoCatalogFactory, TypeManager typeManager) {
        this.trinoCatalogFactory = Objects.requireNonNull(trinoCatalogFactory, "trinoCatalogFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorTableFunction get() {
        return new ClassLoaderSafeConnectorTableFunction((ConnectorTableFunction)new TableChangesFunction(this.trinoCatalogFactory, this.typeManager), this.getClass().getClassLoader());
    }
}

