/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.functions.tablechanges;

import com.google.common.collect.Iterators;
import com.google.common.io.Closer;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesSplit;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.SplitWeight;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.iceberg.AddedRowsScanTask;
import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeletedDataFileScanTask;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.SplittableScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;

public class TableChangesSplitSource
implements ConnectorSplitSource {
    private final Table icebergTable;
    private final IncrementalChangelogScan tableScan;
    private final long targetSplitSize;
    private final Closer closer = Closer.create();
    private CloseableIterable<ChangelogScanTask> changelogScanIterable;
    private CloseableIterator<ChangelogScanTask> changelogScanIterator;
    private Iterator<? extends ChangelogScanTask> fileTasksIterator = Collections.emptyIterator();

    public TableChangesSplitSource(Table icebergTable, IncrementalChangelogScan tableScan) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "table is null");
        this.tableScan = Objects.requireNonNull(tableScan, "tableScan is null");
        this.targetSplitSize = tableScan.targetSplitSize();
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
        if (this.changelogScanIterable == null) {
            try {
                this.changelogScanIterable = (CloseableIterable)this.closer.register((Closeable)this.tableScan.planFiles());
                this.changelogScanIterator = (CloseableIterator)this.closer.register((Closeable)this.changelogScanIterable.iterator());
            }
            catch (UnsupportedOperationException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table uses features which are not yet supported by the table_changes function", (Throwable)e);
            }
        }
        ArrayList<ConnectorSplit> splits = new ArrayList<ConnectorSplit>(maxSize);
        while (splits.size() < maxSize && (this.fileTasksIterator.hasNext() || this.changelogScanIterator.hasNext())) {
            if (!this.fileTasksIterator.hasNext()) {
                ChangelogScanTask wholeFileTask = (ChangelogScanTask)this.changelogScanIterator.next();
                this.fileTasksIterator = TableChangesSplitSource.splitIfPossible(wholeFileTask, this.targetSplitSize);
                continue;
            }
            ChangelogScanTask next = this.fileTasksIterator.next();
            splits.add(this.toIcebergSplit(next));
        }
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished()));
    }

    public boolean isFinished() {
        return this.changelogScanIterator != null && !this.changelogScanIterator.hasNext() && !this.fileTasksIterator.hasNext();
    }

    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Iterator<? extends ChangelogScanTask> splitIfPossible(ChangelogScanTask wholeFileScan, long targetSplitSize) {
        if (wholeFileScan instanceof AddedRowsScanTask) {
            return ((SplittableScanTask)wholeFileScan).split(targetSplitSize).iterator();
        }
        if (wholeFileScan instanceof DeletedDataFileScanTask) {
            return ((SplittableScanTask)wholeFileScan).split(targetSplitSize).iterator();
        }
        return Iterators.singletonIterator((Object)wholeFileScan);
    }

    private ConnectorSplit toIcebergSplit(ChangelogScanTask task) {
        if (task instanceof AddedRowsScanTask) {
            return this.toSplit((AddedRowsScanTask)task);
        }
        if (task instanceof DeletedDataFileScanTask) {
            return this.toSplit((DeletedDataFileScanTask)task);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ChangelogScanTask type is not supported:" + String.valueOf(task));
    }

    private TableChangesSplit toSplit(AddedRowsScanTask task) {
        return new TableChangesSplit(TableChangesSplit.ChangeType.ADDED_FILE, task.commitSnapshotId(), DateTimeEncoding.packDateTimeWithZone((long)this.icebergTable.snapshot(task.commitSnapshotId()).timestampMillis(), (TimeZoneKey)TimeZoneKey.UTC_KEY), task.changeOrdinal(), ((DataFile)task.file()).location(), task.start(), task.length(), ((DataFile)task.file()).fileSizeInBytes(), ((DataFile)task.file()).recordCount(), IcebergFileFormat.fromIceberg(((DataFile)task.file()).format()), PartitionSpecParser.toJson((PartitionSpec)task.spec()), PartitionData.toJson(((DataFile)task.file()).partition()), SplitWeight.standard(), this.icebergTable.io().properties());
    }

    private TableChangesSplit toSplit(DeletedDataFileScanTask task) {
        return new TableChangesSplit(TableChangesSplit.ChangeType.DELETED_FILE, task.commitSnapshotId(), DateTimeEncoding.packDateTimeWithZone((long)this.icebergTable.snapshot(task.commitSnapshotId()).timestampMillis(), (TimeZoneKey)TimeZoneKey.UTC_KEY), task.changeOrdinal(), ((DataFile)task.file()).location(), task.start(), task.length(), ((DataFile)task.file()).fileSizeInBytes(), ((DataFile)task.file()).recordCount(), IcebergFileFormat.fromIceberg(((DataFile)task.file()).format()), PartitionSpecParser.toJson((PartitionSpec)task.spec()), PartitionData.toJson(((DataFile)task.file()).partition()), SplitWeight.standard(), this.icebergTable.io().properties());
    }
}

