/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.procedure;

import com.google.common.base.Enums;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.log.Logger;
import io.airlift.slice.Slices;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.Column;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.RawHiveMetastoreFactory;
import io.trino.metastore.Storage;
import io.trino.metastore.StorageFormat;
import io.trino.plugin.hive.HiveMetadata;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.util.HiveTypeUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergSecurityConfig;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.procedure.MigrationUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class MigrateProcedure
implements Provider<Procedure> {
    private static final Logger log = Logger.get(MigrateProcedure.class);
    public static final String PROVIDER_PROPERTY_KEY = "provider";
    public static final String PROVIDER_PROPERTY_VALUE = "iceberg";
    private final TrinoCatalogFactory catalogFactory;
    private final HiveMetastoreFactory metastoreFactory;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TypeManager typeManager;
    private final int formatVersion;
    private final boolean isUsingSystemSecurity;
    private static final MethodHandle MIGRATE;

    @Inject
    public MigrateProcedure(TrinoCatalogFactory catalogFactory, @RawHiveMetastoreFactory HiveMetastoreFactory metastoreFactory, TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, IcebergConfig icebergConfig, IcebergSecurityConfig securityConfig) {
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
        this.metastoreFactory = Objects.requireNonNull(metastoreFactory, "metastoreFactory is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.formatVersion = icebergConfig.getFormatVersion();
        this.isUsingSystemSecurity = securityConfig.getSecuritySystem() == IcebergSecurityConfig.IcebergSecurity.SYSTEM;
    }

    public Procedure get() {
        return new Procedure("system", "migrate", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA_NAME", (io.trino.spi.type.Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE_NAME", (io.trino.spi.type.Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("RECURSIVE_DIRECTORY", (io.trino.spi.type.Type)VarcharType.VARCHAR, false, (Object)Slices.utf8Slice((String)"fail"))), MIGRATE.bindTo(this));
    }

    public void migrate(ConnectorSession session, String schemaName, String tableName, String recursiveDirectory) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doMigrate(session, schemaName, tableName, recursiveDirectory);
        }
    }

    public void doMigrate(ConnectorSession session, String schemaName, String tableName, String recursiveDirectory) {
        SchemaTableName sourceTableName = new SchemaTableName(schemaName, tableName);
        TrinoCatalog catalog = this.catalogFactory.create(session.getIdentity());
        HiveMetastore metastore = this.metastoreFactory.createMetastore(Optional.of(session.getIdentity()));
        MigrationUtils.RecursiveDirectory recursive = (MigrationUtils.RecursiveDirectory)((Object)Enums.getIfPresent(MigrationUtils.RecursiveDirectory.class, (String)recursiveDirectory.toUpperCase(Locale.ENGLISH)).toJavaUtil().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Invalid recursive_directory: " + recursiveDirectory)));
        io.trino.metastore.Table hiveTable = (io.trino.metastore.Table)metastore.getTable(schemaName, tableName).orElseThrow(() -> new TableNotFoundException(sourceTableName));
        String transactionalProperty = (String)hiveTable.getParameters().get("transactional");
        if (Boolean.parseBoolean(transactionalProperty)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Migrating transactional tables is unsupported");
        }
        if (!"MANAGED_TABLE".equalsIgnoreCase(hiveTable.getTableType()) && !"EXTERNAL_TABLE".equalsIgnoreCase(hiveTable.getTableType())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The procedure doesn't support migrating %s table type".formatted(hiveTable.getTableType()));
        }
        if (HiveUtil.isDeltaLakeTable((io.trino.metastore.Table)hiveTable)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The procedure doesn't support migrating Delta Lake tables");
        }
        if (HiveUtil.isHudiTable((io.trino.metastore.Table)hiveTable)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The procedure doesn't support migrating Hudi tables");
        }
        if (HiveUtil.isIcebergTable((io.trino.metastore.Table)hiveTable)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The table is already an Iceberg table");
        }
        HiveStorageFormat storageFormat = HiveMetadata.extractHiveStorageFormat((StorageFormat)hiveTable.getStorage().getStorageFormat());
        Schema schema = this.toIcebergSchema(Streams.concat((Stream[])new Stream[]{hiveTable.getDataColumns().stream(), hiveTable.getPartitionColumns().stream()}).toList(), MigrateProcedure.toIcebergFileFormat(storageFormat));
        NameMapping nameMapping = MappingUtil.create((Schema)schema);
        String location = hiveTable.getStorage().getLocation();
        Map<String, String> properties = this.icebergTableProperties(location, hiveTable.getParameters(), nameMapping, MigrateProcedure.toIcebergFileFormat(storageFormat));
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, MigrateProcedure.getPartitionColumnNames(hiveTable));
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            ImmutableList.Builder dataFilesBuilder = ImmutableList.builder();
            if (hiveTable.getPartitionColumns().isEmpty()) {
                log.debug("Building data files from %s", new Object[]{location});
                dataFilesBuilder.addAll(MigrationUtils.buildDataFiles(fileSystem, recursive, storageFormat, location, partitionSpec, Optional.empty(), schema));
            } else {
                Map<String, Optional<Partition>> partitions = this.listAllPartitions(metastore, hiveTable);
                int fileCount = 1;
                for (Map.Entry<String, Optional<Partition>> partition : partitions.entrySet()) {
                    Storage storage = partition.getValue().orElseThrow().getStorage();
                    log.debug("Building data files from '%s' for partition %d of %d", new Object[]{storage.getLocation(), fileCount++, partitions.size()});
                    HiveStorageFormat partitionStorageFormat = HiveMetadata.extractHiveStorageFormat((StorageFormat)storage.getStorageFormat());
                    PartitionData partitionData = DataFiles.data((PartitionSpec)partitionSpec, (String)partition.getKey());
                    dataFilesBuilder.addAll(MigrationUtils.buildDataFiles(fileSystem, recursive, partitionStorageFormat, storage.getLocation(), partitionSpec, Optional.of(partitionData), schema));
                }
            }
            log.debug("Start new transaction");
            Transaction transaction = catalog.newCreateTableTransaction(session, sourceTableName, schema, PartitionFields.parsePartitionFields(schema, MigrateProcedure.toPartitionFields(hiveTable)), SortOrder.unsorted(), location, properties);
            ImmutableList dataFiles = dataFilesBuilder.build();
            log.debug("Append data %d data files", new Object[]{dataFiles.size()});
            Table table = transaction.table();
            AppendFiles append = table.newAppend();
            dataFiles.forEach(arg_0 -> ((AppendFiles)append).appendFile(arg_0));
            append.commit();
            log.debug("Set preparatory table properties in a metastore for migrations");
            PrincipalPrivileges principalPrivileges = this.isUsingSystemSecurity ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet((String)session.getUser());
            io.trino.metastore.Table newTable = io.trino.metastore.Table.builder((io.trino.metastore.Table)hiveTable).setParameter("metadata_location", location).setParameter("table_type", PROVIDER_PROPERTY_VALUE.toUpperCase(Locale.ENGLISH)).build();
            metastore.replaceTable(schemaName, tableName, newTable, principalPrivileges);
            transaction.commitTransaction();
            log.debug("Successfully migrated %s table to Iceberg format", new Object[]{sourceTableName});
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to migrate table", (Throwable)e);
        }
    }

    private Map<String, String> icebergTableProperties(String location, Map<String, String> hiveTableProperties, NameMapping nameMapping, IcebergFileFormat fileFormat) {
        HashMap<String, String> icebergTableProperties = new HashMap<String, String>();
        icebergTableProperties.putAll(hiveTableProperties);
        icebergTableProperties.remove("path");
        icebergTableProperties.remove("transient_lastDdlTime");
        icebergTableProperties.remove("serialization.format");
        icebergTableProperties.put("migrated", "true");
        icebergTableProperties.putIfAbsent("location", location);
        icebergTableProperties.put(PROVIDER_PROPERTY_KEY, PROVIDER_PROPERTY_VALUE);
        icebergTableProperties.put("metadata_location", location);
        icebergTableProperties.put("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)nameMapping));
        icebergTableProperties.put("write.format.default", fileFormat.name());
        icebergTableProperties.put("format-version", String.valueOf(this.formatVersion));
        return ImmutableMap.copyOf(icebergTableProperties);
    }

    private Schema toIcebergSchema(List<Column> columns, IcebergFileFormat storageFormat) {
        AtomicInteger nextFieldId = new AtomicInteger(1);
        ArrayList<Types.NestedField> icebergColumns = new ArrayList<Types.NestedField>();
        for (Column column : columns) {
            int index = icebergColumns.size();
            Type type = MigrateProcedure.toIcebergType(this.typeManager.getType(HiveTypeUtil.getTypeSignature((HiveType)column.getType(), (HiveTimestampPrecision)HiveTimestampPrecision.MILLISECONDS)), nextFieldId, storageFormat);
            Types.NestedField field = Types.NestedField.optional((int)index, (String)column.getName(), (Type)type, (String)column.getComment().orElse(null));
            icebergColumns.add(field);
        }
        Types.StructType icebergSchema = Types.StructType.of(icebergColumns);
        icebergSchema = TypeUtil.assignFreshIds((Type)icebergSchema, new AtomicInteger(1)::getAndIncrement);
        return new Schema(icebergSchema.asStructType().fields());
    }

    private static Type toIcebergType(io.trino.spi.type.Type type, AtomicInteger nextFieldId, IcebergFileFormat storageFormat) {
        Type type2;
        io.trino.spi.type.Type type3 = type;
        Objects.requireNonNull(type3);
        io.trino.spi.type.Type type4 = type3;
        int n = 0;
        block12: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TinyintType.class, SmallintType.class, TimestampType.class, RowType.class, ArrayType.class, MapType.class}, (io.trino.spi.type.Type)type4, n)) {
                case 0: 
                case 1: {
                    if (!(type4 instanceof TinyintType) && !(type4 instanceof SmallintType)) {
                        n = 2;
                        continue block12;
                    }
                    type2 = Types.IntegerType.get();
                    break block12;
                }
                case 2: {
                    switch (storageFormat) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case ORC: {
                            type2 = Types.TimestampType.withoutZone();
                            break block12;
                        }
                        case PARQUET: {
                            type2 = Types.TimestampType.withZone();
                            break block12;
                        }
                        case AVRO: 
                    }
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Migrating timestamp type with Avro format is not supported.");
                }
                case 3: {
                    RowType rowType = (RowType)type4;
                    type2 = MigrateProcedure.fromRow(rowType, nextFieldId, storageFormat);
                    break block12;
                }
                case 4: {
                    ArrayType arrayType = (ArrayType)type4;
                    type2 = MigrateProcedure.fromArray(arrayType, nextFieldId, storageFormat);
                    break block12;
                }
                case 5: {
                    MapType mapType = (MapType)type4;
                    type2 = MigrateProcedure.fromMap(mapType, nextFieldId, storageFormat);
                    break block12;
                }
                default: {
                    type2 = TypeConverter.toIcebergTypeForNewColumn(type, nextFieldId);
                    break block12;
                }
            }
            break;
        }
        return type2;
    }

    private static Type fromRow(RowType type, AtomicInteger nextFieldId, IcebergFileFormat storageFormat) {
        HashSet<String> fieldNames = new HashSet<String>();
        ArrayList<Types.NestedField> fields = new ArrayList<Types.NestedField>();
        for (int i = 0; i < type.getFields().size(); ++i) {
            int id = nextFieldId.getAndIncrement();
            RowType.Field field = (RowType.Field)type.getFields().get(i);
            String name = (String)field.getName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Row type field does not have a name: " + type.getDisplayName()));
            if (!fieldNames.add(name.toLowerCase(Locale.ENGLISH))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, "Field name '%s' specified more than once".formatted(name.toLowerCase(Locale.ENGLISH)));
            }
            Type icebergTypeInternal = MigrateProcedure.toIcebergType(field.getType(), nextFieldId, storageFormat);
            fields.add(Types.NestedField.optional((int)id, (String)name, (Type)icebergTypeInternal));
        }
        return Types.StructType.of(fields);
    }

    private static Type fromArray(ArrayType type, AtomicInteger nextFieldId, IcebergFileFormat storageFormat) {
        int id = nextFieldId.getAndIncrement();
        return Types.ListType.ofOptional((int)id, (Type)MigrateProcedure.toIcebergType(type.getElementType(), nextFieldId, storageFormat));
    }

    private static Type fromMap(MapType type, AtomicInteger nextFieldId, IcebergFileFormat storageFormat) {
        int keyId = nextFieldId.getAndIncrement();
        int valueId = nextFieldId.getAndIncrement();
        return Types.MapType.ofOptional((int)keyId, (int)valueId, (Type)MigrateProcedure.toIcebergType(type.getKeyType(), nextFieldId, storageFormat), (Type)MigrateProcedure.toIcebergType(type.getValueType(), nextFieldId, storageFormat));
    }

    public Map<String, Optional<Partition>> listAllPartitions(HiveMetastore metastore, io.trino.metastore.Table table) {
        List partitionNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        Optional partitions = metastore.getPartitionNamesByFilter(table.getDatabaseName(), table.getTableName(), partitionNames, TupleDomain.all());
        if (partitions.isEmpty()) {
            return ImmutableMap.of();
        }
        return metastore.getPartitionsByNames(table, (List)partitions.get());
    }

    private static IcebergFileFormat toIcebergFileFormat(HiveStorageFormat storageFormat) {
        return switch (storageFormat) {
            case HiveStorageFormat.ORC -> IcebergFileFormat.ORC;
            case HiveStorageFormat.PARQUET -> IcebergFileFormat.PARQUET;
            case HiveStorageFormat.AVRO -> IcebergFileFormat.AVRO;
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported storage format: " + String.valueOf(storageFormat));
        };
    }

    private static List<String> toPartitionFields(io.trino.metastore.Table table) {
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.addAll(MigrateProcedure.getPartitionColumnNames(table));
        return fields.build();
    }

    private static List<String> getPartitionColumnNames(io.trino.metastore.Table table) {
        return (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
    }

    static {
        try {
            MIGRATE = MethodHandles.lookup().unreflect(MigrateProcedure.class.getMethod("migrate", ConnectorSession.class, String.class, String.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

