/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import java.util.Map;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.util.LocationUtil;

public class DefaultLocationProvider
implements LocationProvider {
    private final String dataLocation;

    public DefaultLocationProvider(String tableLocation, Map<String, String> properties) {
        this.dataLocation = LocationUtil.stripTrailingSlash((String)DefaultLocationProvider.dataLocation(properties, tableLocation));
    }

    private static String dataLocation(Map<String, String> properties, String tableLocation) {
        String dataLocation = properties.get("write.data.path");
        if (dataLocation == null && (dataLocation = properties.get("write.folder-storage.path")) == null) {
            dataLocation = String.format("%s/data", LocationUtil.stripTrailingSlash((String)tableLocation));
        }
        return dataLocation;
    }

    public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
        return "%s/%s/%s".formatted(this.dataLocation, spec.partitionToPath(partitionData), filename);
    }

    public String newDataLocation(String filename) {
        return "%s/%s".formatted(this.dataLocation, filename);
    }
}

