/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.trino.filesystem.Location;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.util.LocationUtil;

public class ObjectStoreLocationProvider
implements LocationProvider {
    private static final HashFunction HASH_FUNC = Hashing.murmur3_32_fixed();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private final String storageLocation;
    private final String context;

    public ObjectStoreLocationProvider(String tableLocation, Map<String, String> properties) {
        this.storageLocation = LocationUtil.stripTrailingSlash((String)ObjectStoreLocationProvider.dataLocation(properties, tableLocation));
        this.context = this.storageLocation.startsWith(LocationUtil.stripTrailingSlash((String)tableLocation)) ? null : ObjectStoreLocationProvider.pathContext(tableLocation);
    }

    private static String dataLocation(Map<String, String> properties, String tableLocation) {
        String dataLocation = properties.get("write.data.path");
        if (dataLocation == null && (dataLocation = properties.get("write.object-storage.path")) == null && (dataLocation = properties.get("write.folder-storage.path")) == null) {
            dataLocation = "%s/data".formatted(LocationUtil.stripTrailingSlash((String)tableLocation));
        }
        return dataLocation;
    }

    public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
        return this.newDataLocation("%s/%s".formatted(spec.partitionToPath(partitionData), filename));
    }

    public String newDataLocation(String filename) {
        String hash = ObjectStoreLocationProvider.computeHash(filename);
        if (this.context != null) {
            return "%s/%s/%s/%s".formatted(this.storageLocation, hash, this.context, filename);
        }
        return "%s/%s/%s".formatted(this.storageLocation, hash, filename);
    }

    private static String pathContext(String tableLocation) {
        String name;
        Location location;
        try {
            location = Location.of((String)LocationUtil.stripTrailingSlash((String)tableLocation));
            name = location.fileName();
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return null;
        }
        try {
            String parent = LocationUtil.stripTrailingSlash((String)location.parentDirectory().path());
            parent = parent.substring(parent.lastIndexOf(47) + 1);
            return "%s/%s".formatted(parent, name);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return name;
        }
    }

    private static String computeHash(String fileName) {
        byte[] bytes = HASH_FUNC.hashString((CharSequence)fileName, StandardCharsets.UTF_8).asBytes();
        return BASE64_ENCODER.encodeToString(bytes);
    }
}

