/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import com.google.common.math.LongMath;
import io.trino.spi.block.Block;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import java.math.RoundingMode;

public final class Timestamps {
    private Timestamps() {
    }

    public static long timestampTzToMicros(LongTimestampWithTimeZone timestamp) {
        return timestamp.getEpochMillis() * 1000L + LongMath.divide((long)timestamp.getPicosOfMilli(), (long)1000000L, (RoundingMode)RoundingMode.UNNECESSARY);
    }

    public static LongTimestampWithTimeZone timestampTzFromMicros(long epochMicros) {
        long epochMillis = Math.floorDiv(epochMicros, 1000);
        int picosOfMillis = Math.floorMod(epochMicros, 1000) * 1000000;
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)picosOfMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }

    public static LongTimestampWithTimeZone getTimestampTz(Block block, int position) {
        return (LongTimestampWithTimeZone)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.getObject(block, position);
    }
}

