/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.snowflake;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.snowflake.IcebergSnowflakeCatalogConfig;
import io.trino.plugin.iceberg.catalog.snowflake.TrinoSnowflakeCatalog;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import jakarta.annotation.PreDestroy;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.iceberg.IcebergBuild;
import org.apache.iceberg.jdbc.JdbcClientPool;
import org.apache.iceberg.snowflake.JdbcSnowflakeClient;
import org.apache.iceberg.snowflake.SnowflakeCatalog;
import org.apache.iceberg.snowflake.SnowflakeClient;
import org.apache.iceberg.snowflake.TrinoIcebergSnowflakeCatalogFileIOFactory;

public class TrinoIcebergSnowflakeCatalogFactory
implements TrinoCatalogFactory {
    private static final String JDBC_APPLICATION_PROPERTY = "application";
    private static final String APP_IDENTIFIER = "iceberg-snowflake-catalog";
    private static final String JDBC_USER_AGENT_SUFFIX_PROPERTY = "user_agent_suffix";
    private static final int UNIQUE_ID_LENGTH = 20;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final CatalogName catalogName;
    private final TypeManager typeManager;
    private final IcebergTableOperationsProvider tableOperationsProvider;
    private final String snowflakeDatabase;
    private final Map<String, String> snowflakeDriverProperties;
    private final JdbcClientPool snowflakeConnectionPool;

    @Inject
    public TrinoIcebergSnowflakeCatalogFactory(TrinoFileSystemFactory fileSystemFactory, CatalogName catalogName, IcebergSnowflakeCatalogConfig snowflakeCatalogConfig, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.snowflakeDriverProperties = TrinoIcebergSnowflakeCatalogFactory.getSnowflakeDriverProperties(snowflakeCatalogConfig.getUri(), snowflakeCatalogConfig.getUser(), snowflakeCatalogConfig.getPassword(), snowflakeCatalogConfig.getRole());
        this.snowflakeDatabase = snowflakeCatalogConfig.getDatabase();
        this.snowflakeConnectionPool = new JdbcClientPool(snowflakeCatalogConfig.getUri().toString(), this.snowflakeDriverProperties);
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationsProvider is null");
    }

    @PreDestroy
    public void shutdown() {
        this.snowflakeConnectionPool.close();
    }

    @Override
    public synchronized TrinoCatalog create(ConnectorIdentity identity) {
        JdbcSnowflakeClient snowflakeClient = new JdbcSnowflakeClient(this.snowflakeConnectionPool);
        SnowflakeCatalog icebergSnowflakeCatalog = new SnowflakeCatalog();
        icebergSnowflakeCatalog.initialize(this.catalogName.toString(), (SnowflakeClient)snowflakeClient, (SnowflakeCatalog.FileIOFactory)new TrinoIcebergSnowflakeCatalogFileIOFactory(this.fileSystemFactory, identity), this.snowflakeDriverProperties);
        return new TrinoSnowflakeCatalog(icebergSnowflakeCatalog, this.catalogName, this.typeManager, this.fileSystemFactory, this.tableOperationsProvider, this.snowflakeDatabase);
    }

    public static Map<String, String> getSnowflakeDriverProperties(URI snowflakeUri, String snowflakeUser, String snowflakePassword, Optional<String> snowflakeRole) {
        String uniqueId = UUID.randomUUID().toString().replace("-", "").substring(0, 20);
        String uniqueAppIdentifier = "iceberg-snowflake-catalog_" + uniqueId;
        String userAgentSuffix = IcebergBuild.fullVersion() + " " + uniqueAppIdentifier;
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"jdbc.user", (Object)snowflakeUser).put((Object)"jdbc.password", (Object)snowflakePassword).put((Object)"uri", (Object)snowflakeUri.toString()).put((Object)"jdbc.JDBC_QUERY_RESULT_FORMAT", (Object)"JSON").put((Object)"jdbc.application", (Object)uniqueAppIdentifier).put((Object)"jdbc.user_agent_suffix", (Object)userAgentSuffix);
        snowflakeRole.ifPresent(role -> properties.put((Object)"jdbc.role", role));
        return properties.buildOrThrow();
    }
}

