/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v3.lzo;

import io.airlift.compress.v3.Decompressor;
import io.airlift.compress.v3.MalformedInputException;
import io.airlift.compress.v3.lzo.LzoRawDecompressor;
import io.airlift.compress.v3.lzo.UnsafeUtil;
import java.lang.foreign.MemorySegment;
import java.lang.ref.Reference;
import java.util.Objects;
import sun.misc.Unsafe;

public class LzoDecompressor
implements Decompressor {
    @Override
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        LzoDecompressor.verifyRange(input, inputOffset, inputLength);
        LzoDecompressor.verifyRange(output, outputOffset, maxOutputLength);
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long inputLimit = inputAddress + (long)inputLength;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        long outputLimit = outputAddress + (long)maxOutputLength;
        return LzoRawDecompressor.decompress(input, inputAddress, inputLimit, output, outputAddress, outputLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decompress(MemorySegment input, MemorySegment output) throws MalformedInputException {
        try {
            byte[] inputBase = UnsafeUtil.getBase(input);
            long inputAddress = UnsafeUtil.getAddress(input);
            long inputLimit = Math.addExact(inputAddress, input.byteSize());
            byte[] outputBase = UnsafeUtil.getBase(output);
            long outputAddress = UnsafeUtil.getAddress(output);
            long outputLimit = Math.addExact(outputAddress, output.byteSize());
            int n = LzoRawDecompressor.decompress(inputBase, inputAddress, inputLimit, outputBase, outputAddress, outputLimit);
            return n;
        }
        finally {
            Reference.reachabilityFence(input);
            Reference.reachabilityFence(output);
        }
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

