/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import com.google.common.collect.ImmutableList;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import okhttp3.internal.tls.DistinguishedNameParser;
import okhttp3.internal.tls.OkHostnameVerifier;

public class LegacyHostnameVerifier
implements HostnameVerifier {
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;
    private static final Pattern VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
    public static final HostnameVerifier INSTANCE = new LegacyHostnameVerifier();

    private LegacyHostnameVerifier() {
    }

    @Override
    public boolean verify(String host, SSLSession session) {
        if (OkHostnameVerifier.INSTANCE.verify(host, session)) {
            return true;
        }
        if (this.verifyAsIpAddress(host)) {
            return false;
        }
        try {
            Certificate[] certificates = session.getPeerCertificates();
            X509Certificate certificate = (X509Certificate)certificates[0];
            if (!this.allSubjectAltNames(certificate).isEmpty()) {
                return false;
            }
            X500Principal principal = certificate.getSubjectX500Principal();
            String cn = new DistinguishedNameParser(principal).findMostSpecific("cn");
            if (cn != null) {
                return this.verifyHostname(host, cn);
            }
            return false;
        }
        catch (SSLException e) {
            return false;
        }
    }

    private boolean verifyAsIpAddress(String host) {
        return VERIFY_AS_IP_ADDRESS.matcher(host).matches();
    }

    private boolean verifyHostname(String hostName, String pattern) {
        if (hostName == null || hostName.length() == 0 || hostName.startsWith(".") || hostName.endsWith("..")) {
            return false;
        }
        if (pattern == null || pattern.length() == 0 || pattern.startsWith(".") || pattern.endsWith("..")) {
            return false;
        }
        if (!hostName.endsWith(".")) {
            hostName = hostName + '.';
        }
        if (!pattern.endsWith(".")) {
            pattern = pattern + '.';
        }
        if (!(pattern = pattern.toLowerCase(Locale.US)).contains("*")) {
            return hostName.equals(pattern);
        }
        if (!pattern.startsWith("*.") || pattern.indexOf(42, 1) != -1) {
            return false;
        }
        if (hostName.length() < pattern.length()) {
            return false;
        }
        if ("*.".equals(pattern)) {
            return false;
        }
        String suffix = pattern.substring(1);
        if (!hostName.endsWith(suffix)) {
            return false;
        }
        int suffixStartIndexInHostName = hostName.length() - suffix.length();
        return suffixStartIndexInHostName <= 0 || hostName.lastIndexOf(46, suffixStartIndexInHostName - 1) == -1;
    }

    private List<String> allSubjectAltNames(X509Certificate certificate) {
        return ImmutableList.builder().addAll(this.allSubjectAltNames(certificate, 7)).addAll(this.allSubjectAltNames(certificate, 2)).build();
    }

    private List<String> allSubjectAltNames(X509Certificate certificate, int type) {
        ImmutableList.Builder result = ImmutableList.builder();
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                return ImmutableList.of();
            }
            for (List<?> subjectAltName : subjectAltNames) {
                String altName;
                Integer altNameType;
                List<?> entry = subjectAltName;
                if (entry == null || entry.size() < 2 || (altNameType = (Integer)entry.get(0)) == null || altNameType != type || (altName = (String)entry.get(1)) == null) continue;
                result.add((Object)altName);
            }
            return result.build();
        }
        catch (CertificateParsingException e) {
            return ImmutableList.of();
        }
    }
}

