/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ranger;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.plugin.ranger.RangerConfig;
import io.trino.plugin.ranger.RangerTrinoAccessRequest;
import io.trino.plugin.ranger.RangerTrinoAccessType;
import io.trino.plugin.ranger.RangerTrinoEventListener;
import io.trino.plugin.ranger.RangerTrinoResource;
import io.trino.spi.QueryId;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.connector.EntityPrivilege;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.io.File;
import java.net.URL;
import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;

public class RangerSystemAccessControl
implements SystemAccessControl {
    private static final Logger LOG = Logger.get(RangerSystemAccessControl.class);
    public static final String RANGER_TRINO_SERVICETYPE = "trino";
    public static final String RANGER_TRINO_APPID = "trino";
    private final RangerBasePlugin rangerPlugin;
    private final RangerTrinoEventListener eventListener = new RangerTrinoEventListener();

    @Inject
    public RangerSystemAccessControl(RangerConfig config) throws Exception {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getServiceName()) ? 1 : 0) != 0, (Object)"ranger.service.name is not configured");
        Configuration hadoopConf = new Configuration();
        for (File configPath : config.getHadoopConfigResource()) {
            URL url = configPath.toURI().toURL();
            LOG.info("Loading Hadoop config %s from url %s", new Object[]{configPath, url});
            hadoopConf.addResource(url);
        }
        UserGroupInformation.setConfiguration((Configuration)hadoopConf);
        RangerPluginConfig pluginConfig = new RangerPluginConfig("trino", config.getServiceName(), "trino", null, null, null);
        for (File configPath : config.getPluginConfigResource()) {
            pluginConfig.addResourceIfReadable(configPath.getAbsolutePath());
        }
        this.rangerPlugin = new RangerBasePlugin(pluginConfig);
        this.rangerPlugin.init();
        this.rangerPlugin.setResultProcessor((RangerAccessResultProcessor)new RangerDefaultAuditHandler());
    }

    public void checkCanImpersonateUser(Identity identity, String userName) {
        if (!this.hasPermission(RangerTrinoResource.forUser(userName), identity, null, RangerTrinoAccessType.IMPERSONATE, "ImpersonateUser")) {
            AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)userName);
        }
    }

    @Deprecated
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        if (!this.hasPermission(RangerTrinoResource.forUser(userName), principal, null, RangerTrinoAccessType.IMPERSONATE, "SetUser")) {
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
    }

    public void checkCanExecuteQuery(Identity identity, QueryId queryId) {
        if (!this.hasPermission(RangerTrinoResource.forQueryId(queryId.getId()), identity, queryId, RangerTrinoAccessType.EXECUTE, "ExecuteQuery")) {
            AccessDeniedException.denyExecuteQuery();
        }
    }

    public void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner) {
        if (!this.hasPermission(RangerTrinoResource.forUser(queryOwner.getUser()), identity, null, RangerTrinoAccessType.IMPERSONATE, "ViewQueryOwnedBy")) {
            AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)queryOwner.getUser());
        }
    }

    public Collection<Identity> filterViewQueryOwnedBy(Identity identity, Collection<Identity> queryOwners) {
        HashSet<Identity> toExclude = new HashSet<Identity>();
        for (Identity queryOwner : queryOwners) {
            if (this.hasPermissionForFilter(RangerTrinoResource.forUser(queryOwner.getUser()), identity, null, RangerTrinoAccessType.IMPERSONATE, "filterViewQueryOwnedBy")) continue;
            toExclude.add(queryOwner);
        }
        if (toExclude.isEmpty()) {
            return queryOwners;
        }
        return queryOwners.stream().filter(Predicate.not(toExclude::contains)).collect(Collectors.toList());
    }

    public void checkCanKillQueryOwnedBy(Identity identity, Identity queryOwner) {
        if (!this.hasPermission(RangerTrinoResource.forUser(queryOwner.getUser()), identity, null, RangerTrinoAccessType.IMPERSONATE, "KillQueryOwnedBy")) {
            AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)queryOwner.getUser());
        }
    }

    public void checkCanReadSystemInformation(Identity identity) {
        if (!this.hasPermission(RangerTrinoResource.forSystemInformation(), identity, null, RangerTrinoAccessType.READ_SYSINFO, "ReadSystemInformation")) {
            AccessDeniedException.denyReadSystemInformationAccess();
        }
    }

    public void checkCanWriteSystemInformation(Identity identity) {
        if (!this.hasPermission(RangerTrinoResource.forSystemInformation(), identity, null, RangerTrinoAccessType.WRITE_SYSINFO, "WriteSystemInformation")) {
            AccessDeniedException.denyWriteSystemInformationAccess();
        }
    }

    public void checkCanSetSystemSessionProperty(Identity identity, QueryId queryId, String propertyName) {
        if (!this.hasPermission(RangerTrinoResource.forSystemProperty(propertyName), identity, queryId, RangerTrinoAccessType.ALTER, "SetSystemSessionProperty")) {
            AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
        }
    }

    public boolean canAccessCatalog(SystemSecurityContext context, String catalogName) {
        return this.hasPermission(RangerTrinoResource.forCatalog(catalogName), context, RangerTrinoAccessType._ANY, "AccessCatalog");
    }

    public void checkCanCreateCatalog(SystemSecurityContext context, String catalogName) {
        if (!this.hasPermission(RangerTrinoResource.forCatalog(catalogName), context, RangerTrinoAccessType.CREATE, "CreateCatalog")) {
            AccessDeniedException.denyCreateCatalog((String)catalogName);
        }
    }

    public void checkCanDropCatalog(SystemSecurityContext context, String catalogName) {
        if (!this.hasPermission(RangerTrinoResource.forCatalog(catalogName), context, RangerTrinoAccessType.DROP, "DropCatalog")) {
            AccessDeniedException.denyDropCatalog((String)catalogName);
        }
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        if (!this.hasPermission(RangerTrinoResource.forSessionProperty(catalogName, propertyName), context, RangerTrinoAccessType.ALTER, "SetCatalogSessionProperty")) {
            AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
        }
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        HashSet<String> toExclude = new HashSet<String>();
        for (String catalog : catalogs) {
            if (this.hasPermissionForFilter(RangerTrinoResource.forCatalog(catalog), context, RangerTrinoAccessType._ANY, "filterCatalogs")) continue;
            toExclude.add(catalog);
        }
        if (toExclude.isEmpty()) {
            return catalogs;
        }
        return catalogs.stream().filter(Predicate.not(toExclude::contains)).collect(Collectors.toSet());
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema, Map<String, Object> properties) {
        if (!this.hasPermission(RangerTrinoResource.forSchema(schema.getCatalogName(), schema.getSchemaName()), context, RangerTrinoAccessType.CREATE, "CreateSchema")) {
            AccessDeniedException.denyCreateSchema((String)schema.getSchemaName());
        }
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerTrinoResource.forSchema(schema.getCatalogName(), schema.getSchemaName()), context, RangerTrinoAccessType.DROP, "DropSchema")) {
            AccessDeniedException.denyDropSchema((String)schema.getSchemaName());
        }
    }

    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        boolean isAllowed;
        boolean bl = isAllowed = this.hasPermission(RangerTrinoResource.forSchema(schema.getCatalogName(), schema.getSchemaName()), context, RangerTrinoAccessType.ALTER, "RenameSchema:source") && this.hasPermission(RangerTrinoResource.forSchema(schema.getCatalogName(), newSchemaName), context, RangerTrinoAccessType.ALTER, "RenameSchema:target");
        if (!isAllowed) {
            AccessDeniedException.denyRenameSchema((String)schema.getSchemaName(), (String)newSchemaName);
        }
    }

    public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, TrinoPrincipal principal) {
        if (!this.hasPermission(RangerTrinoResource.forSchema(schema.getCatalogName(), schema.getSchemaName()), context, RangerTrinoAccessType.ALTER, "SetSchemaAuthorization")) {
            AccessDeniedException.denySetSchemaAuthorization((String)schema.getSchemaName(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        if (!this.hasPermission(RangerTrinoResource.forCatalog(catalogName), context, RangerTrinoAccessType._ANY, "ShowSchemas")) {
            AccessDeniedException.denyShowSchemas((String)catalogName);
        }
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        HashSet<String> toExclude = new HashSet<String>();
        for (String schemaName : schemaNames) {
            if (this.hasPermissionForFilter(RangerTrinoResource.forSchema(catalogName, schemaName), context, RangerTrinoAccessType._ANY, "filterSchemas")) continue;
            toExclude.add(schemaName);
        }
        if (toExclude.isEmpty()) {
            return schemaNames;
        }
        return schemaNames.stream().filter(Predicate.not(toExclude::contains)).collect(Collectors.toSet());
    }

    public void checkCanShowCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerTrinoResource.forSchema(schema.getCatalogName(), schema.getSchemaName()), context, RangerTrinoAccessType.SHOW, "ShowCreateSchema")) {
            AccessDeniedException.denyShowCreateSchema((String)schema.getSchemaName());
        }
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Object> properties) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.CREATE, "CreateTable")) {
            AccessDeniedException.denyCreateTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.DROP, "DropTable")) {
            AccessDeniedException.denyDropTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        boolean isAllowed;
        boolean bl = isAllowed = this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.ALTER, "RenameTable:source") && this.hasPermission(RangerSystemAccessControl.createTableResource(newTable), context, RangerTrinoAccessType.ALTER, "RenameTable:target");
        if (!isAllowed) {
            AccessDeniedException.denyRenameTable((String)table.getSchemaTableName().getTableName(), (String)newTable.getSchemaTableName().getTableName());
        }
    }

    public void checkCanSetTableProperties(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Optional<Object>> properties) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.ALTER, "SetTableProperties")) {
            AccessDeniedException.denySetTableProperties((String)table.toString());
        }
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.ALTER, "SetTableComment")) {
            AccessDeniedException.denyCommentTable((String)table.toString());
        }
    }

    public void checkCanSetTableAuthorization(SystemSecurityContext context, CatalogSchemaTableName table, TrinoPrincipal principal) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.ALTER, "SetTableAuthorization")) {
            AccessDeniedException.denySetTableAuthorization((String)table.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerTrinoResource.forSchema(schema.getCatalogName(), schema.getSchemaName()), context, RangerTrinoAccessType._ANY, "ShowTables")) {
            AccessDeniedException.denyShowTables((String)schema.toString());
        }
    }

    public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.SHOW, "ShowCreateTable")) {
            AccessDeniedException.denyShowCreateTable((String)table.toString());
        }
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.INSERT, "InsertIntoTable")) {
            AccessDeniedException.denyInsertTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.DELETE, "DeleteFromTable")) {
            AccessDeniedException.denyDeleteTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanTruncateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.DELETE, "TruncateTable")) {
            AccessDeniedException.denyTruncateTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        HashSet<SchemaTableName> toExclude = new HashSet<SchemaTableName>();
        for (SchemaTableName tableName : tableNames) {
            RangerTrinoResource resource = RangerTrinoResource.forTable(catalogName, tableName.getSchemaName(), tableName.getTableName());
            if (this.hasPermissionForFilter(resource, context, RangerTrinoAccessType._ANY, "filterTables")) continue;
            toExclude.add(tableName);
        }
        if (toExclude.isEmpty()) {
            return tableNames;
        }
        return tableNames.stream().filter(Predicate.not(toExclude::contains)).collect(Collectors.toSet());
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.ALTER, "AddColumn")) {
            AccessDeniedException.denyAddColumn((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanAlterColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.ALTER, "AlterColumn")) {
            AccessDeniedException.denyAlterColumn((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.ALTER, "DropColumn")) {
            AccessDeniedException.denyDropColumn((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.ALTER, "RenameColumn")) {
            AccessDeniedException.denyRenameColumn((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanSetColumnComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.ALTER, "SetColumnComment")) {
            AccessDeniedException.denyCommentColumn((String)table.toString());
        }
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType._ANY, "ShowColumns")) {
            AccessDeniedException.denyShowColumns((String)table.toString());
        }
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        for (RangerTrinoResource resource : RangerTrinoResource.forColumns(table.getCatalogName(), table.getSchemaTableName().getSchemaName(), table.getSchemaTableName().getTableName(), columns)) {
            if (this.hasPermission(resource, context, RangerTrinoAccessType.SELECT, "SelectFromColumns")) continue;
            AccessDeniedException.denySelectColumns((String)table.getSchemaTableName().getTableName(), columns);
        }
    }

    public void checkCanUpdateTableColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> updatedColumnNames) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(table), context, RangerTrinoAccessType.INSERT, "UpdateTableColumns")) {
            AccessDeniedException.denyUpdateTableColumns((String)table.getSchemaTableName().getTableName(), updatedColumnNames);
        }
    }

    @Deprecated
    public Set<String> filterColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        HashSet<String> toExclude = new HashSet<String>();
        String catalogName = table.getCatalogName();
        String schemaName = table.getSchemaTableName().getSchemaName();
        String tableName = table.getSchemaTableName().getTableName();
        for (String column : columns) {
            RangerTrinoResource resource = RangerTrinoResource.forColumn(catalogName, schemaName, tableName, column);
            if (this.hasPermissionForFilter(resource, context, RangerTrinoAccessType._ANY, "filterColumns")) continue;
            toExclude.add(column);
        }
        if (toExclude.isEmpty()) {
            return columns;
        }
        return columns.stream().filter(Predicate.not(toExclude::contains)).collect(Collectors.toSet());
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(view), context, RangerTrinoAccessType.CREATE, "CreateView")) {
            AccessDeniedException.denyCreateView((String)view.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(view), context, RangerTrinoAccessType.DROP, "DropView")) {
            AccessDeniedException.denyDropView((String)view.getSchemaTableName().getTableName());
        }
    }

    public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        boolean isAllowed;
        boolean bl = isAllowed = this.hasPermission(RangerSystemAccessControl.createTableResource(view), context, RangerTrinoAccessType.ALTER, "RenameView:source") && this.hasPermission(RangerSystemAccessControl.createTableResource(newView), context, RangerTrinoAccessType.ALTER, "RenameView:target");
        if (!isAllowed) {
            AccessDeniedException.denyRenameView((String)view.toString(), (String)newView.toString());
        }
    }

    public void checkCanSetViewAuthorization(SystemSecurityContext context, CatalogSchemaTableName view, TrinoPrincipal principal) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(view), context, RangerTrinoAccessType.ALTER, "SetViewAuthorization")) {
            AccessDeniedException.denySetViewAuthorization((String)view.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        for (RangerTrinoResource resource : RangerTrinoResource.forColumns(table.getCatalogName(), table.getSchemaTableName().getSchemaName(), table.getSchemaTableName().getTableName(), columns)) {
            if (this.hasPermission(resource, context, RangerTrinoAccessType.SELECT, "CreateViewWithSelectFromColumns")) continue;
            AccessDeniedException.denyCreateViewWithSelect((String)table.getSchemaTableName().getTableName(), (Identity)context.getIdentity());
        }
    }

    public void checkCanSetViewComment(SystemSecurityContext context, CatalogSchemaTableName view) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(view), context, RangerTrinoAccessType.ALTER, "SetViewComment")) {
            AccessDeniedException.denyCommentView((String)view.toString());
        }
    }

    public void checkCanCreateMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Object> properties) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(materializedView), context, RangerTrinoAccessType.CREATE, "CreateMaterializedView")) {
            AccessDeniedException.denyCreateMaterializedView((String)materializedView.getSchemaTableName().getTableName());
        }
    }

    public void checkCanRefreshMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(materializedView), context, RangerTrinoAccessType.ALTER, "RefreshMaterializedView")) {
            AccessDeniedException.denyRefreshMaterializedView((String)materializedView.toString());
        }
    }

    public void checkCanSetMaterializedViewProperties(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Optional<Object>> properties) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(materializedView), context, RangerTrinoAccessType.ALTER, "SetMaterializedViewProperties")) {
            AccessDeniedException.denySetMaterializedViewProperties((String)materializedView.toString());
        }
    }

    public void checkCanDropMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(materializedView), context, RangerTrinoAccessType.DROP, "DropMaterializedView")) {
            AccessDeniedException.denyDropMaterializedView((String)materializedView.getSchemaTableName().getTableName());
        }
    }

    public void checkCanRenameMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView, CatalogSchemaTableName newView) {
        boolean isAllowed;
        boolean bl = isAllowed = this.hasPermission(RangerSystemAccessControl.createTableResource(materializedView), context, RangerTrinoAccessType.ALTER, "RenameMaterializedView:source") && this.hasPermission(RangerSystemAccessControl.createTableResource(newView), context, RangerTrinoAccessType.ALTER, "RenameMaterializedView:target");
        if (!isAllowed) {
            AccessDeniedException.denyRenameMaterializedView((String)materializedView.toString(), (String)newView.toString());
        }
    }

    public void checkCanGrantSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee, boolean grantOption) {
    }

    public void checkCanDenySchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee) {
    }

    public void checkCanRevokeSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal revokee, boolean grantOption) {
    }

    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee, boolean withGrantOption) {
    }

    public void checkCanDenyTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee) {
    }

    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal revokee, boolean grantOptionFor) {
    }

    public void checkCanGrantEntityPrivilege(SystemSecurityContext context, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal grantee, boolean grantOption) {
    }

    public void checkCanDenyEntityPrivilege(SystemSecurityContext context, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal grantee) {
    }

    public void checkCanRevokeEntityPrivilege(SystemSecurityContext context, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal revokee, boolean grantOption) {
    }

    public void checkCanCreateRole(SystemSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
    }

    public void checkCanDropRole(SystemSecurityContext context, String role) {
    }

    public void checkCanShowRoles(SystemSecurityContext context) {
    }

    public void checkCanGrantRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
    }

    public void checkCanRevokeRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
    }

    public void checkCanShowCurrentRoles(SystemSecurityContext context) {
    }

    public void checkCanShowRoleGrants(SystemSecurityContext context) {
    }

    public void checkCanExecuteProcedure(SystemSecurityContext context, CatalogSchemaRoutineName procedure) {
        if (!this.hasPermission(RangerTrinoResource.forSchemaProcedure(procedure.getCatalogName(), procedure.getSchemaRoutineName().getSchemaName(), procedure.getSchemaRoutineName().getRoutineName()), context, RangerTrinoAccessType.EXECUTE, "ExecuteProcedure")) {
            AccessDeniedException.denyExecuteProcedure((String)procedure.getSchemaRoutineName().getRoutineName());
        }
    }

    public void checkCanExecuteTableProcedure(SystemSecurityContext context, CatalogSchemaTableName catalogSchemaTableName, String procedure) {
        if (!this.hasPermission(RangerSystemAccessControl.createTableResource(catalogSchemaTableName), context, RangerTrinoAccessType.ALTER, "ExecuteTableProcedure")) {
            AccessDeniedException.denyExecuteTableProcedure((String)catalogSchemaTableName.toString(), (String)procedure);
        }
    }

    public void checkCanCreateFunction(SystemSecurityContext context, CatalogSchemaRoutineName functionName) {
        if (!this.hasPermission(RangerTrinoResource.forSchemaFunction(functionName.getCatalogName(), functionName.getSchemaRoutineName().getSchemaName(), functionName.getSchemaRoutineName().getRoutineName()), context, RangerTrinoAccessType.CREATE, "CreateFunction")) {
            AccessDeniedException.denyCreateFunction((String)functionName.toString());
        }
    }

    public void checkCanDropFunction(SystemSecurityContext context, CatalogSchemaRoutineName functionName) {
        if (!this.hasPermission(RangerTrinoResource.forSchemaFunction(functionName.getCatalogName(), functionName.getSchemaRoutineName().getSchemaName(), functionName.getSchemaRoutineName().getRoutineName()), context, RangerTrinoAccessType.DROP, "DropFunction")) {
            AccessDeniedException.denyDropFunction((String)functionName.toString());
        }
    }

    public void checkCanShowCreateFunction(SystemSecurityContext context, CatalogSchemaRoutineName functionName) {
        if (!this.hasPermission(RangerTrinoResource.forSchemaFunction(functionName.getCatalogName(), functionName.getSchemaRoutineName().getSchemaName(), functionName.getSchemaRoutineName().getRoutineName()), context, RangerTrinoAccessType.SHOW, "ShowCreateFunction")) {
            AccessDeniedException.denyShowCreateFunction((String)functionName.toString());
        }
    }

    public void checkCanShowFunctions(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerTrinoResource.forSchema(schema.getCatalogName(), schema.getSchemaName()), context, RangerTrinoAccessType._ANY, "ShowFunctions")) {
            AccessDeniedException.denyShowFunctions((String)schema.toString());
        }
    }

    public boolean canExecuteFunction(SystemSecurityContext context, CatalogSchemaRoutineName functionName) {
        return this.hasPermission(RangerTrinoResource.forSchemaFunction(functionName.getCatalogName(), functionName.getSchemaRoutineName().getSchemaName(), functionName.getSchemaRoutineName().getRoutineName()), context, RangerTrinoAccessType.EXECUTE, "ExecuteFunction");
    }

    public boolean canCreateViewWithExecuteFunction(SystemSecurityContext context, CatalogSchemaRoutineName functionName) {
        return this.hasPermission(RangerTrinoResource.forSchemaFunction(functionName.getCatalogName(), functionName.getSchemaRoutineName().getSchemaName(), functionName.getSchemaRoutineName().getRoutineName()), context, RangerTrinoAccessType.EXECUTE, "CreateViewWithExecuteFunction");
    }

    public Set<SchemaFunctionName> filterFunctions(SystemSecurityContext context, String catalogName, Set<SchemaFunctionName> functionNames) {
        HashSet<SchemaFunctionName> toExclude = new HashSet<SchemaFunctionName>();
        for (SchemaFunctionName functionName : functionNames) {
            RangerTrinoResource resource = RangerTrinoResource.forSchemaFunction(catalogName, functionName.getSchemaName(), functionName.getFunctionName());
            if (this.hasPermissionForFilter(resource, context, RangerTrinoAccessType._ANY, "filterFunctions")) continue;
            toExclude.add(functionName);
        }
        if (toExclude.isEmpty()) {
            return functionNames;
        }
        return functionNames.stream().filter(Predicate.not(toExclude::contains)).collect(Collectors.toSet());
    }

    public List<ViewExpression> getRowFilters(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        RangerAccessResult result = this.getRowFilterResult(this.createAccessRequest(RangerSystemAccessControl.createTableResource(tableName), context, RangerTrinoAccessType.SELECT, "getRowFilters"));
        if (!RangerSystemAccessControl.isRowFilterEnabled(result)) {
            return Collections.emptyList();
        }
        String filter = result.getFilterExpr();
        ViewExpression viewExpression = ViewExpression.builder().identity(context.getIdentity().getUser()).catalog(tableName.getCatalogName()).schema(tableName.getSchemaTableName().getSchemaName()).expression(filter).build();
        return ImmutableList.of((Object)viewExpression);
    }

    public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        RangerAccessResult result = this.getDataMaskResult(this.createAccessRequest(RangerTrinoResource.forColumn(tableName.getCatalogName(), tableName.getSchemaTableName().getSchemaName(), tableName.getSchemaTableName().getTableName(), columnName), context, RangerTrinoAccessType.SELECT, "getColumnMask"));
        if (!RangerSystemAccessControl.isDataMaskEnabled(result)) {
            return Optional.empty();
        }
        String maskType = result.getMaskType();
        RangerServiceDef.RangerDataMaskTypeDef maskTypeDef = result.getMaskTypeDef();
        String transformer = null;
        if (maskTypeDef != null) {
            transformer = maskTypeDef.getTransformer();
        }
        if ("MASK_NULL".equalsIgnoreCase(maskType)) {
            transformer = "NULL";
        } else if ("CUSTOM".equalsIgnoreCase(maskType)) {
            String maskedValue = result.getMaskedValue();
            transformer = Objects.requireNonNullElse(maskedValue, "NULL");
        }
        if (transformer == null) {
            return Optional.empty();
        }
        transformer = transformer.replace("{col}", columnName).replace("{type}", type.getDisplayName());
        return Optional.of(ViewExpression.builder().identity(context.getIdentity().getUser()).catalog(tableName.getCatalogName()).schema(tableName.getSchemaTableName().getSchemaName()).expression(transformer).build());
    }

    public Iterable<EventListener> getEventListeners() {
        return ImmutableList.of((Object)this.eventListener);
    }

    public void shutdown() {
        this.rangerPlugin.cleanup();
    }

    private RangerAccessResult getDataMaskResult(RangerTrinoAccessRequest request) {
        return this.rangerPlugin.evalDataMaskPolicies((RangerAccessRequest)request, this.rangerPlugin.getResultProcessor());
    }

    private RangerAccessResult getRowFilterResult(RangerTrinoAccessRequest request) {
        return this.rangerPlugin.evalRowFilterPolicies((RangerAccessRequest)request, this.rangerPlugin.getResultProcessor());
    }

    private static boolean isDataMaskEnabled(RangerAccessResult result) {
        return result.isMaskEnabled();
    }

    private static boolean isRowFilterEnabled(RangerAccessResult result) {
        return result.isRowFilterEnabled();
    }

    private RangerTrinoAccessRequest createAccessRequest(RangerTrinoResource resource, SystemSecurityContext context, RangerTrinoAccessType accessType, String action) {
        Set userGroups = context.getIdentity().getGroups();
        return new RangerTrinoAccessRequest(resource, context.getIdentity().getUser(), userGroups, this.getQueryTime(context), this.getClientAddress(context), this.getClientType(context), this.getQueryText(context), accessType, action);
    }

    private RangerTrinoAccessRequest createAccessRequest(RangerTrinoResource resource, Identity identity, QueryId queryId, RangerTrinoAccessType accessType, String action) {
        Set userGroups = identity.getGroups();
        return new RangerTrinoAccessRequest(resource, identity.getUser(), userGroups, this.getQueryTime(queryId), this.getClientAddress(queryId), this.getClientType(queryId), this.getQueryText(queryId), accessType, action);
    }

    private Optional<String> getClientAddress(QueryId queryId) {
        return queryId != null ? this.eventListener.getClientAddress(queryId.getId()) : Optional.empty();
    }

    private Optional<String> getClientType(QueryId queryId) {
        return queryId != null ? this.eventListener.getClientType(queryId.getId()) : Optional.empty();
    }

    private Optional<String> getQueryText(QueryId queryId) {
        return queryId != null ? this.eventListener.getQueryText(queryId.getId()) : Optional.empty();
    }

    private Optional<Instant> getQueryTime(QueryId queryId) {
        return queryId != null ? this.eventListener.getQueryTime(queryId.getId()) : Optional.empty();
    }

    private Optional<String> getClientAddress(SystemSecurityContext context) {
        return context != null ? this.getClientAddress(context.getQueryId()) : Optional.empty();
    }

    private Optional<String> getClientType(SystemSecurityContext context) {
        return context != null ? this.getClientType(context.getQueryId()) : Optional.empty();
    }

    private Optional<String> getQueryText(SystemSecurityContext context) {
        return context != null ? this.getQueryText(context.getQueryId()) : Optional.empty();
    }

    private Optional<Instant> getQueryTime(SystemSecurityContext context) {
        return context != null ? this.getQueryTime(context.getQueryId()) : Optional.empty();
    }

    private boolean hasPermission(RangerTrinoResource resource, SystemSecurityContext context, RangerTrinoAccessType accessType, String action) {
        RangerAccessResult result = this.rangerPlugin.isAccessAllowed((RangerAccessRequest)this.createAccessRequest(resource, context, accessType, action));
        return result != null && result.getIsAllowed();
    }

    private boolean hasPermissionForFilter(RangerTrinoResource resource, SystemSecurityContext context, RangerTrinoAccessType accessType, String action) {
        RangerTrinoAccessRequest request = this.createAccessRequest(resource, context, accessType, action);
        request.setResourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS);
        RangerAccessResult result = this.rangerPlugin.isAccessAllowed((RangerAccessRequest)request, null);
        return result != null && result.getIsAllowed();
    }

    private boolean hasPermission(RangerTrinoResource resource, Identity identity, QueryId queryId, RangerTrinoAccessType accessType, String action) {
        RangerAccessResult result = this.rangerPlugin.isAccessAllowed((RangerAccessRequest)this.createAccessRequest(resource, identity, queryId, accessType, action));
        return result != null && result.getIsAllowed();
    }

    private boolean hasPermissionForFilter(RangerTrinoResource resource, Identity identity, QueryId queryId, RangerTrinoAccessType accessType, String action) {
        RangerTrinoAccessRequest request = this.createAccessRequest(resource, identity, queryId, accessType, action);
        request.setResourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS);
        RangerAccessResult result = this.rangerPlugin.isAccessAllowed((RangerAccessRequest)request, null);
        return result != null && result.getIsAllowed();
    }

    private boolean hasPermission(RangerTrinoResource resource, Optional<Principal> principal, QueryId queryId, RangerTrinoAccessType accessType, String action) {
        RangerAccessResult result = this.rangerPlugin.isAccessAllowed((RangerAccessRequest)this.createAccessRequest(resource, RangerSystemAccessControl.toIdentity(principal), queryId, accessType, action));
        return result != null && result.getIsAllowed();
    }

    private static RangerTrinoResource createTableResource(CatalogSchemaTableName catalogSchemaTableName) {
        return RangerTrinoResource.forTable(catalogSchemaTableName.getCatalogName(), catalogSchemaTableName.getSchemaTableName().getSchemaName(), catalogSchemaTableName.getSchemaTableName().getTableName());
    }

    private static Identity toIdentity(Optional<Principal> principal) {
        if (principal.isPresent()) {
            return Identity.ofUser((String)principal.get().getName());
        }
        return Identity.ofUser((String)"");
    }
}

