/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ranger;

import io.trino.plugin.ranger.RangerTrinoAccessType;
import io.trino.plugin.ranger.RangerTrinoResource;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;

class RangerTrinoAccessRequest
extends RangerAccessRequestImpl {
    public RangerTrinoAccessRequest(RangerTrinoResource resource, String user, Set<String> userGroups, Optional<Instant> queryTime, Optional<String> clientAddress, Optional<String> clientType, Optional<String> queryText, RangerTrinoAccessType trinoAccessType, String action) {
        super((RangerAccessResource)resource, trinoAccessType.name().toLowerCase(Locale.ENGLISH), user, userGroups, null);
        this.setAction(action);
        this.setAccessTime(queryTime.map(instant -> new Date(instant.getEpochSecond() * 1000L)).orElseGet(Date::new));
        this.setClientIPAddress(clientAddress.orElse(null));
        this.setClientType(clientType.orElse(null));
        this.setRequestData(queryText.orElse(null));
    }
}

