/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.trino.metastore.HivePrincipal;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.PrivilegeInfo;
import java.util.Objects;
import java.util.Set;

@Immutable
public class HivePrivilegeInfo {
    private final HivePrivilege hivePrivilege;
    private final boolean grantOption;
    private final HivePrincipal grantor;
    private final HivePrincipal grantee;

    @JsonCreator
    public HivePrivilegeInfo(@JsonProperty(value="hivePrivilege") HivePrivilege hivePrivilege, @JsonProperty(value="grantOption") boolean grantOption, @JsonProperty(value="grantor") HivePrincipal grantor, @JsonProperty(value="grantee") HivePrincipal grantee) {
        this.hivePrivilege = Objects.requireNonNull(hivePrivilege, "hivePrivilege is null");
        this.grantOption = grantOption;
        this.grantor = Objects.requireNonNull(grantor, "grantor is null");
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
    }

    @JsonProperty
    public HivePrivilege getHivePrivilege() {
        return this.hivePrivilege;
    }

    @JsonProperty
    public boolean isGrantOption() {
        return this.grantOption;
    }

    @JsonProperty
    public HivePrincipal getGrantor() {
        return this.grantor;
    }

    @JsonProperty
    public HivePrincipal getGrantee() {
        return this.grantee;
    }

    public static HivePrivilege toHivePrivilege(Privilege privilege) {
        return switch (privilege) {
            case Privilege.SELECT -> HivePrivilege.SELECT;
            case Privilege.INSERT -> HivePrivilege.INSERT;
            case Privilege.DELETE -> HivePrivilege.DELETE;
            case Privilege.UPDATE -> HivePrivilege.UPDATE;
            default -> throw new IllegalArgumentException("Unexpected privilege: " + String.valueOf(privilege));
        };
    }

    public boolean isContainedIn(HivePrivilegeInfo hivePrivilegeInfo) {
        return this.getHivePrivilege() == hivePrivilegeInfo.getHivePrivilege() && (this.isGrantOption() == hivePrivilegeInfo.isGrantOption() || !this.isGrantOption() && hivePrivilegeInfo.isGrantOption());
    }

    public Set<PrivilegeInfo> toPrivilegeInfo() {
        return switch (this.hivePrivilege.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ImmutableSet.of((Object)new PrivilegeInfo(Privilege.SELECT, this.isGrantOption()));
            case 1 -> ImmutableSet.of((Object)new PrivilegeInfo(Privilege.INSERT, this.isGrantOption()));
            case 3 -> ImmutableSet.of((Object)new PrivilegeInfo(Privilege.DELETE, this.isGrantOption()));
            case 2 -> ImmutableSet.of((Object)new PrivilegeInfo(Privilege.UPDATE, this.isGrantOption()));
            case 4 -> ImmutableSet.of();
        };
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hivePrivilege, this.grantOption, this.grantor, this.grantee});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePrivilegeInfo hivePrivilegeInfo = (HivePrivilegeInfo)o;
        return this.hivePrivilege == hivePrivilegeInfo.hivePrivilege && this.grantOption == hivePrivilegeInfo.grantOption && Objects.equals(this.grantor, hivePrivilegeInfo.grantor) && Objects.equals(this.grantee, hivePrivilegeInfo.grantee);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("privilege", (Object)this.hivePrivilege).add("grantOption", this.grantOption).add("grantor", (Object)this.grantor).add("grantee", (Object)this.grantee).toString();
    }

    public static enum HivePrivilege {
        SELECT,
        INSERT,
        UPDATE,
        DELETE,
        OWNERSHIP;

    }
}

