/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;

public final class Partitions {
    public static final String HIVE_DEFAULT_DYNAMIC_PARTITION = "__HIVE_DEFAULT_PARTITION__";
    private static final HexFormat HEX_UPPER_FORMAT = HexFormat.of().withUpperCase();
    private static final CharMatcher PATH_CHAR_TO_ESCAPE = CharMatcher.inRange((char)'\u0000', (char)'\u001f').or(CharMatcher.anyOf((CharSequence)"\"#%'*/:=?\\\u007f{[]^")).precomputed();

    private Partitions() {
    }

    public static List<String> toPartitionValues(String partitionName) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        int start = 0;
        while (true) {
            int end;
            if (start < partitionName.length() && partitionName.charAt(start) != '=') {
                ++start;
                continue;
            }
            for (end = ++start; end < partitionName.length() && partitionName.charAt(end) != '/'; ++end) {
            }
            if (start > partitionName.length()) break;
            resultBuilder.add((Object)Partitions.unescapePathName(partitionName.substring(start, end)));
            start = end + 1;
        }
        return resultBuilder.build();
    }

    public static String unescapePathName(String path) {
        int escapedAtIndex = path.indexOf(37);
        if (escapedAtIndex < 0 || escapedAtIndex + 2 >= path.length()) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        int fromIndex = 0;
        while (escapedAtIndex >= 0 && escapedAtIndex + 2 < path.length()) {
            if (escapedAtIndex > fromIndex) {
                sb.append(path, fromIndex, escapedAtIndex);
            }
            try {
                int code = HexFormat.fromHexDigits(path, escapedAtIndex + 1, escapedAtIndex + 3);
                sb.append((char)code);
                fromIndex = escapedAtIndex + 3;
            }
            catch (NumberFormatException e) {
                sb.append('%');
                fromIndex = escapedAtIndex + 1;
            }
            escapedAtIndex = path.indexOf(37, fromIndex);
        }
        if (fromIndex < path.length()) {
            sb.append(path, fromIndex, path.length());
        }
        return sb.toString();
    }

    public static String escapePathName(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return HIVE_DEFAULT_DYNAMIC_PARTITION;
        }
        int escapeAtIndex = PATH_CHAR_TO_ESCAPE.indexIn((CharSequence)path);
        if (escapeAtIndex < 0) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        int fromIndex = 0;
        while (escapeAtIndex >= 0 && escapeAtIndex < path.length()) {
            if (escapeAtIndex > fromIndex) {
                sb.append(path, fromIndex, escapeAtIndex);
            }
            char c = path.charAt(escapeAtIndex);
            sb.append('%').append(HEX_UPPER_FORMAT.toHighHexDigit(c)).append(HEX_UPPER_FORMAT.toLowHexDigit(c));
            fromIndex = escapeAtIndex + 1;
            if (fromIndex < path.length()) {
                escapeAtIndex = PATH_CHAR_TO_ESCAPE.indexIn((CharSequence)path, fromIndex);
                continue;
            }
            escapeAtIndex = -1;
        }
        if (fromIndex < path.length()) {
            sb.append(path, fromIndex, path.length());
        }
        return sb.toString();
    }

    public static String makePartName(List<String> columns, List<String> values) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                name.append('/');
            }
            name.append(Partitions.escapePathName(columns.get(i).toLowerCase(Locale.ENGLISH)));
            name.append('=');
            name.append(Partitions.escapePathName(values.get(i)));
        }
        return name.toString();
    }
}

