/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore.cache;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Comparators;
import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class CachingHiveMetastoreConfig {
    public static final Duration DEFAULT_STATS_CACHE_TTL = new Duration(5.0, TimeUnit.MINUTES);
    private Duration metastoreCacheTtl = new Duration(0.0, TimeUnit.SECONDS);
    private Optional<Duration> statsCacheTtl = Optional.empty();
    private Optional<Duration> metastoreRefreshInterval = Optional.empty();
    private long metastoreCacheMaximumSize = 20000L;
    private int maxMetastoreRefreshThreads = 10;
    private boolean partitionCacheEnabled = true;
    private boolean cacheMissing = true;
    private Boolean cacheMissingPartitions;
    private Boolean cacheMissingStats;

    @NotNull
    public Duration getMetastoreCacheTtl() {
        return this.metastoreCacheTtl;
    }

    @Config(value="hive.metastore-cache-ttl")
    public CachingHiveMetastoreConfig setMetastoreCacheTtl(Duration metastoreCacheTtl) {
        this.metastoreCacheTtl = metastoreCacheTtl;
        return this;
    }

    @NotNull
    public Duration getStatsCacheTtl() {
        return this.statsCacheTtl.orElseGet(() -> (Duration)Comparators.max((Comparable)this.metastoreCacheTtl, (Comparable)DEFAULT_STATS_CACHE_TTL));
    }

    @Config(value="hive.metastore-stats-cache-ttl")
    public CachingHiveMetastoreConfig setStatsCacheTtl(Duration statsCacheTtl) {
        this.statsCacheTtl = Optional.of(statsCacheTtl);
        return this;
    }

    public @NotNull Optional<@MinDuration(value="1ms") Duration> getMetastoreRefreshInterval() {
        return this.metastoreRefreshInterval;
    }

    @Config(value="hive.metastore-refresh-interval")
    public CachingHiveMetastoreConfig setMetastoreRefreshInterval(Duration metastoreRefreshInterval) {
        this.metastoreRefreshInterval = Optional.ofNullable(metastoreRefreshInterval);
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getMetastoreCacheMaximumSize() {
        return this.metastoreCacheMaximumSize;
    }

    @Config(value="hive.metastore-cache-maximum-size")
    public CachingHiveMetastoreConfig setMetastoreCacheMaximumSize(long metastoreCacheMaximumSize) {
        this.metastoreCacheMaximumSize = metastoreCacheMaximumSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxMetastoreRefreshThreads() {
        return this.maxMetastoreRefreshThreads;
    }

    @Config(value="hive.metastore-refresh-max-threads")
    public CachingHiveMetastoreConfig setMaxMetastoreRefreshThreads(int maxMetastoreRefreshThreads) {
        this.maxMetastoreRefreshThreads = maxMetastoreRefreshThreads;
        return this;
    }

    public boolean isPartitionCacheEnabled() {
        return this.partitionCacheEnabled;
    }

    @Config(value="hive.metastore-cache.cache-partitions")
    public CachingHiveMetastoreConfig setPartitionCacheEnabled(boolean enabled) {
        this.partitionCacheEnabled = enabled;
        return this;
    }

    public boolean isCacheMissing() {
        return this.cacheMissing;
    }

    @Config(value="hive.metastore-cache.cache-missing")
    public CachingHiveMetastoreConfig setCacheMissing(boolean cacheMissing) {
        this.cacheMissing = cacheMissing;
        return this;
    }

    public boolean isCacheMissingPartitions() {
        return (Boolean)MoreObjects.firstNonNull((Object)this.cacheMissingPartitions, (Object)this.cacheMissing);
    }

    @Config(value="hive.metastore-cache.cache-missing-partitions")
    public CachingHiveMetastoreConfig setCacheMissingPartitions(boolean cacheMissingPartitions) {
        this.cacheMissingPartitions = cacheMissingPartitions;
        return this;
    }

    public boolean isCacheMissingStats() {
        return (Boolean)MoreObjects.firstNonNull((Object)this.cacheMissingStats, (Object)this.cacheMissing);
    }

    @Config(value="hive.metastore-cache.cache-missing-stats")
    public CachingHiveMetastoreConfig setCacheMissingStats(boolean cacheMissingStats) {
        this.cacheMissingStats = cacheMissingStats;
        return this;
    }
}

