/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem;

import io.airlift.slice.Slice;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.ExceptionAttributes;
import io.trino.spi.spool.SpooledLocation;
import io.trino.spi.spool.SpooledSegmentHandle;
import io.trino.spi.spool.SpoolingContext;
import io.trino.spi.spool.SpoolingManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TracingSpoolingManager
implements SpoolingManager {
    public static final AttributeKey<String> SEGMENT_ID = AttributeKey.stringKey((String)"trino.segment.id");
    public static final AttributeKey<String> SEGMENT_QUERY_ID = AttributeKey.stringKey((String)"trino.segment.query_id");
    public static final AttributeKey<String> SEGMENT_ENCODING = AttributeKey.stringKey((String)"trino.segment.encoding");
    public static final AttributeKey<Long> SEGMENT_SIZE = AttributeKey.longKey((String)"trino.segment.size");
    public static final AttributeKey<Long> SEGMENT_ROWS = AttributeKey.longKey((String)"trino.segment.rows");
    public static final AttributeKey<String> SEGMENT_EXPIRATION = AttributeKey.stringKey((String)"trino.segment.expiration");
    private final Tracer tracer;
    private final SpoolingManager delegate;

    TracingSpoolingManager(Tracer tracer, SpoolingManager delegate) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public SpooledSegmentHandle create(SpoolingContext context) {
        Span span = this.tracer.spanBuilder("SpoolingManager.create").setAttribute(SEGMENT_QUERY_ID, (Object)context.queryId().toString()).setAttribute(SEGMENT_ENCODING, (Object)context.encoding()).setAttribute(SEGMENT_ROWS, (Object)context.rows()).setAttribute(SEGMENT_SIZE, (Object)context.size()).startSpan();
        return TracingSpoolingManager.withTracing(span, () -> this.delegate.create(context));
    }

    public OutputStream createOutputStream(SpooledSegmentHandle handle) throws IOException {
        return TracingSpoolingManager.withTracing(TracingSpoolingManager.span(this.tracer, handle, "createOutputStream"), () -> this.delegate.createOutputStream(handle));
    }

    public InputStream openInputStream(SpooledSegmentHandle handle) throws IOException {
        return TracingSpoolingManager.withTracing(TracingSpoolingManager.span(this.tracer, handle, "openInputStream"), () -> this.delegate.openInputStream(handle));
    }

    public void acknowledge(SpooledSegmentHandle handle) throws IOException {
        TracingSpoolingManager.withTracing(TracingSpoolingManager.span(this.tracer, handle, "acknowledge"), () -> this.delegate.acknowledge(handle));
    }

    public Optional<SpooledLocation.DirectLocation> directLocation(SpooledSegmentHandle handle) throws IOException {
        return TracingSpoolingManager.withTracing(TracingSpoolingManager.span(this.tracer, handle, "directLocation"), () -> this.delegate.directLocation(handle));
    }

    public SpooledLocation location(SpooledSegmentHandle handle) throws IOException {
        return TracingSpoolingManager.withTracing(TracingSpoolingManager.span(this.tracer, handle, "location"), () -> this.delegate.location(handle));
    }

    public SpooledSegmentHandle handle(Slice identifier, Map<String, List<String>> headers) {
        return this.delegate.handle(identifier, headers);
    }

    public static <E extends Exception> void withTracing(Span span, CheckedRunnable<E> runnable) throws E {
        TracingSpoolingManager.withTracing(span, () -> {
            runnable.run();
            return null;
        });
    }

    public static Span span(Tracer tracer, SpooledSegmentHandle handle, String name) {
        return tracer.spanBuilder("SpoolingManager." + name).setAttribute(SEGMENT_ID, (Object)handle.identifier()).setAttribute(SEGMENT_ENCODING, (Object)handle.encoding()).setAttribute(SEGMENT_EXPIRATION, (Object)handle.expirationTime().toString()).startSpan();
    }

    public static <T, E extends Exception> T withTracing(Span span, CheckedSupplier<T, E> supplier) throws E {
        try {
            T t;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    t = supplier.get();
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t2) {
                        span.setStatus(StatusCode.ERROR, t2.getMessage());
                        span.recordException(t2, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
                        throw t2;
                    }
                }
                scope.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public static interface CheckedSupplier<T, E extends Exception> {
        public T get() throws E;
    }

    public static interface CheckedRunnable<E extends Exception> {
        public void run() throws E;
    }
}

