/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem.encryption;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import io.trino.filesystem.encryption.EncryptionKey;
import io.trino.spooling.filesystem.encryption.EncryptionHeadersTranslator;
import io.trino.spooling.filesystem.encryption.HeadersUtils;
import java.util.Base64;
import java.util.List;
import java.util.Map;

class S3EncryptionHeadersTranslator
implements EncryptionHeadersTranslator {
    S3EncryptionHeadersTranslator() {
    }

    @Override
    public EncryptionKey extractKey(Map<String, List<String>> headers) {
        byte[] key = Base64.getDecoder().decode(HeadersUtils.getOnlyHeader(headers, "x-amz-server-side-encryption-customer-key"));
        String md5Checksum = HeadersUtils.getOnlyHeader(headers, "x-amz-server-side-encryption-customer-key-md5");
        EncryptionKey encryption = new EncryptionKey(key, HeadersUtils.getOnlyHeader(headers, "x-amz-server-side-encryption-customer-algorithm"));
        Preconditions.checkArgument((boolean)S3EncryptionHeadersTranslator.md5(encryption).equals(md5Checksum), (Object)"Key MD5 checksum does not match");
        return encryption;
    }

    @Override
    public Map<String, List<String>> createHeaders(EncryptionKey encryption) {
        return ImmutableMap.of((Object)"x-amz-server-side-encryption-customer-algorithm", (Object)ImmutableList.of((Object)encryption.algorithm()), (Object)"x-amz-server-side-encryption-customer-key", (Object)ImmutableList.of((Object)S3EncryptionHeadersTranslator.encoded(encryption)), (Object)"x-amz-server-side-encryption-customer-key-md5", (Object)ImmutableList.of((Object)S3EncryptionHeadersTranslator.md5(encryption)));
    }

    public static String encoded(EncryptionKey key) {
        return Base64.getEncoder().encodeToString(key.key());
    }

    public static String md5(EncryptionKey key) {
        return Base64.getEncoder().encodeToString(Hashing.md5().hashBytes(key.key()).asBytes());
    }
}

