/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jmx;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.plugin.jmx.JmxColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public record JmxTableHandle(SchemaTableName tableName, List<String> objectNames, List<JmxColumnHandle> columnHandles, boolean liveData, TupleDomain<ColumnHandle> nodeFilter) implements ConnectorTableHandle
{
    public JmxTableHandle {
        Objects.requireNonNull(tableName, "tableName is null");
        objectNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(objectNames, "objectNames is null"));
        columnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnHandles, "columnHandles is null"));
        Objects.requireNonNull(nodeFilter, "nodeFilter is null");
        Preconditions.checkArgument((!objectNames.isEmpty() ? 1 : 0) != 0, (Object)"objectsNames is empty");
    }

    @JsonIgnore
    public ConnectorTableMetadata getTableMetadata() {
        return new ConnectorTableMetadata(this.tableName, (List)ImmutableList.copyOf((Iterable)Iterables.transform(this.columnHandles, JmxColumnHandle::getColumnMetadata)));
    }
}

