/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.credential;

import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;

public class StaticCredentialProvider
implements CredentialProvider {
    private final Optional<String> connectionUser;
    private final Optional<String> connectionPassword;

    public static StaticCredentialProvider of(String user, String password) {
        return new StaticCredentialProvider(Optional.of(user), Optional.of(password));
    }

    public StaticCredentialProvider(Optional<String> user, Optional<String> password) {
        this.connectionUser = Objects.requireNonNull(user, "user is null");
        this.connectionPassword = Objects.requireNonNull(password, "password is null");
    }

    @Override
    public Optional<String> getConnectionUser(Optional<ConnectorIdentity> jdbcIdentity) {
        return this.connectionUser;
    }

    @Override
    public Optional<String> getConnectionPassword(Optional<ConnectorIdentity> jdbcIdentity) {
        return this.connectionPassword;
    }
}

