/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotBlank;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ser.CommitMetaDeserializer;
import org.projectnessie.model.ser.Views;

@Schema(type=SchemaType.OBJECT, title="CommitMeta", properties={@SchemaProperty(name="hash", pattern="^[0-9a-fA-F]{8,64}$")})
@JsonSerialize(as=ImmutableCommitMeta.class)
@JsonDeserialize(using=CommitMetaDeserializer.class)
@Value.Immutable
public abstract class CommitMeta {
    @javax.annotation.Nullable
    @Nullable
    public abstract String getHash();

    @javax.annotation.Nullable
    @Nullable
    public abstract String getCommitter();

    @javax.annotation.Nullable
    @Nullable
    @JsonView(value={Views.V1.class})
    @Value.Derived
    public String getAuthor() {
        return this.getAllAuthors().isEmpty() ? null : this.getAllAuthors().get(0);
    }

    @NotNull
    @jakarta.validation.constraints.NotNull
    @JsonView(value={Views.V2.class})
    @JsonProperty(value="authors")
    public abstract List<String> getAllAuthors();

    @javax.annotation.Nullable
    @Nullable
    @JsonView(value={Views.V1.class})
    @Value.Derived
    public String getSignedOffBy() {
        return this.getAllSignedOffBy().isEmpty() ? null : this.getAllSignedOffBy().get(0);
    }

    @NotNull
    @jakarta.validation.constraints.NotNull
    @JsonView(value={Views.V2.class})
    public abstract List<String> getAllSignedOffBy();

    @javax.validation.constraints.NotBlank
    @NotBlank
    public abstract String getMessage();

    @javax.annotation.Nullable
    @Nullable
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public abstract Instant getCommitTime();

    @javax.annotation.Nullable
    @Nullable
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public abstract Instant getAuthorTime();

    @NotNull
    @jakarta.validation.constraints.NotNull
    @JsonView(value={Views.V1.class})
    @Value.NonAttribute
    public Map<String, String> getProperties() {
        HashMap<String, String> firstElements = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : this.getAllProperties().entrySet()) {
            List<String> list = entry.getValue();
            if (list.isEmpty()) continue;
            firstElements.put(entry.getKey(), list.get(0));
        }
        return firstElements;
    }

    @NotNull
    @jakarta.validation.constraints.NotNull
    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract Map<String, List<String>> getAllProperties();

    @NotNull
    @jakarta.validation.constraints.NotNull
    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract List<String> getParentCommitHashes();

    public ImmutableCommitMeta.Builder toBuilder() {
        return ImmutableCommitMeta.builder().from(this);
    }

    public static ImmutableCommitMeta.Builder builder() {
        return ImmutableCommitMeta.builder();
    }

    public static CommitMeta fromMessage(String message) {
        return ImmutableCommitMeta.builder().message(message).build();
    }

    public static class InstantDeserializer
    extends StdDeserializer<Instant> {
        public InstantDeserializer() {
            this(null);
        }

        protected InstantDeserializer(Class<?> vc) {
            super(vc);
        }

        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Instant.parse(p.getText());
        }
    }

    public static class InstantSerializer
    extends StdSerializer<Instant> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;

        public InstantSerializer() {
            this(Instant.class);
        }

        protected InstantSerializer(Class<Instant> t) {
            super(t);
        }

        public void serialize(Instant value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(FORMATTER.format(value));
        }
    }

    public static interface Builder {
        public Builder message(String var1);

        default public ImmutableCommitMeta.Builder author(String author) {
            if (author != null) {
                return this.addAllAuthors(author);
            }
            return (ImmutableCommitMeta.Builder)this;
        }

        public ImmutableCommitMeta.Builder addAllAuthors(String var1);

        default public ImmutableCommitMeta.Builder signedOffBy(String author) {
            if (author != null) {
                return this.addAllSignedOffBy(author);
            }
            return (ImmutableCommitMeta.Builder)this;
        }

        public ImmutableCommitMeta.Builder addAllSignedOffBy(String var1);

        default public ImmutableCommitMeta.Builder properties(Map<String, ? extends String> entries) {
            this.allProperties(Collections.emptyMap());
            return this.putAllProperties(entries);
        }

        default public ImmutableCommitMeta.Builder putAllProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> entry : entries.entrySet()) {
                this.putProperties(entry.getKey(), entry.getValue());
            }
            return (ImmutableCommitMeta.Builder)this;
        }

        default public ImmutableCommitMeta.Builder putProperties(Map.Entry<String, ? extends String> entry) {
            return this.putProperties(entry.getKey(), entry.getValue());
        }

        default public ImmutableCommitMeta.Builder putProperties(String key, String value) {
            return this.putAllProperties(key, Collections.singletonList(value));
        }

        public ImmutableCommitMeta.Builder putAllProperties(String var1, List<String> var2);

        public ImmutableCommitMeta.Builder allProperties(Map<String, ? extends List<String>> var1);

        public CommitMeta build();
    }
}

