/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import io.airlift.json.LengthLimitedWriter;
import io.airlift.json.ObjectMapperProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class JsonCodec<T> {
    private static final Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = Suppliers.memoize(() -> new ObjectMapperProvider().get().enable(SerializationFeature.INDENT_OUTPUT));
    private final ObjectMapper mapper;
    private final Type type;
    private final JavaType javaType;

    public static <T> JsonCodec<T> jsonCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new JsonCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type);
    }

    public static <T> JsonCodec<T> jsonCodec(TypeToken<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new JsonCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type.getType());
    }

    public static <T> JsonCodec<List<T>> listJsonCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type).getType();
        return new JsonCodec<List<T>>(OBJECT_MAPPER_SUPPLIER.get(), listType);
    }

    public static <T> JsonCodec<List<T>> listJsonCodec(JsonCodec<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type.getTypeToken()).getType();
        return new JsonCodec<List<T>>(OBJECT_MAPPER_SUPPLIER.get(), listType);
    }

    public static <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, Class<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType).getType();
        return new JsonCodec<Map<K, V>>(OBJECT_MAPPER_SUPPLIER.get(), mapType);
    }

    public static <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, JsonCodec<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType.getTypeToken()).getType();
        return new JsonCodec<Map<K, V>>(OBJECT_MAPPER_SUPPLIER.get(), mapType);
    }

    JsonCodec(ObjectMapper mapper, Type type) {
        this.mapper = mapper;
        this.type = type;
        this.javaType = mapper.getTypeFactory().constructType(type);
    }

    public Type getType() {
        return this.type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T fromJson(String json) throws IllegalArgumentException {
        try (JsonParser parser = this.mapper.createParser(json);){
            Object value = this.mapper.readerFor(this.javaType).readValue(parser);
            Preconditions.checkArgument((parser.nextToken() == null ? 1 : 0) != 0, (Object)"Found characters after the expected end of input");
            Object object = value;
            return (T)object;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON string for %s", this.javaType), e);
        }
    }

    public String toJson(T instance) throws IllegalArgumentException {
        try {
            return this.mapper.writerFor(this.javaType).writeValueAsString(instance);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to JSON", instance.getClass().getName()), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<String> toJsonWithLengthLimit(T instance, int lengthLimit) {
        try (StringWriter stringWriter = new StringWriter();){
            Optional<String> optional;
            try (LengthLimitedWriter lengthLimitedWriter = new LengthLimitedWriter(stringWriter, lengthLimit);){
                this.mapper.writeValue((Writer)lengthLimitedWriter, instance);
                optional = Optional.of(stringWriter.getBuffer().toString());
            }
            return optional;
        }
        catch (LengthLimitedWriter.LengthLimitExceededException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to JSON", instance.getClass().getName()), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T fromJson(byte[] json) throws IllegalArgumentException {
        try (JsonParser parser = this.mapper.createParser(json);){
            Object value = this.mapper.readerFor(this.javaType).readValue(parser);
            Preconditions.checkArgument((parser.nextToken() == null ? 1 : 0) != 0, (Object)"Found characters after the expected end of input");
            Object object = value;
            return (T)object;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON bytes for %s", this.javaType), e);
        }
    }

    public byte[] toJsonBytes(T instance) throws IllegalArgumentException {
        try {
            return this.mapper.writerFor(this.javaType).writeValueAsBytes(instance);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to JSON", instance.getClass().getName()), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T fromJson(InputStream json) throws IllegalArgumentException {
        try (JsonParser parser = this.mapper.createParser(json);){
            Object value = this.mapper.readerFor(this.javaType).readValue(parser);
            Preconditions.checkArgument((parser.nextToken() == null ? 1 : 0) != 0, (Object)"Found characters after the expected end of input");
            Object object = value;
            return (T)object;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON bytes for %s", this.javaType), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T fromJson(Reader json) throws IllegalArgumentException {
        try (JsonParser parser = this.mapper.createParser(json);){
            Object value = this.mapper.readerFor(this.javaType).readValue(parser);
            Preconditions.checkArgument((parser.nextToken() == null ? 1 : 0) != 0, (Object)"Found characters after the expected end of input");
            Object object = value;
            return (T)object;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON characters for %s", this.javaType), e);
        }
    }

    TypeToken<T> getTypeToken() {
        return TypeToken.of((Type)this.type);
    }
}

