/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ExperimentalApi;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingChannelBuilder2;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ManagedChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.AltsChannelCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.GrpcUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsChannelBuilder
extends ForwardingChannelBuilder2<AltsChannelBuilder> {
    private final NettyChannelBuilder delegate;
    private final AltsChannelCredentials.Builder credentialsBuilder = new AltsChannelCredentials.Builder();

    public static AltsChannelBuilder forTarget(String target) {
        return new AltsChannelBuilder(target);
    }

    public static AltsChannelBuilder forAddress(String name, int port) {
        return AltsChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort(name, port));
    }

    private AltsChannelBuilder(String target) {
        this.delegate = NettyChannelBuilder.forTarget(target);
    }

    public AltsChannelBuilder addTargetServiceAccount(String targetServiceAccount) {
        this.credentialsBuilder.addTargetServiceAccount(targetServiceAccount);
        return this;
    }

    public AltsChannelBuilder enableUntrustedAltsForTesting() {
        this.credentialsBuilder.enableUntrustedAltsForTesting();
        return this;
    }

    public AltsChannelBuilder setHandshakerAddressForTesting(String handshakerAddress) {
        this.credentialsBuilder.setHandshakerAddressForTesting(handshakerAddress);
        return this;
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    @Override
    public ManagedChannel build() {
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory(this.delegate(), this.credentialsBuilder.buildProtocolNegotiatorFactory());
        return this.delegate().build();
    }

    @Nullable
    @VisibleForTesting
    InternalProtocolNegotiator.ProtocolNegotiator getProtocolNegotiatorForTest() {
        return this.credentialsBuilder.buildProtocolNegotiatorFactory().newNegotiator();
    }
}

