/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ExperimentalApi;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.util.CertificateUtils;
import com.google.errorprone.annotations.InlineMe;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@IgnoreJRERequirement
public final class AdvancedTlsX509TrustManager
extends X509ExtendedTrustManager {
    private static final Logger log = Logger.getLogger(AdvancedTlsX509TrustManager.class.getName());
    private static final int MINIMUM_REFRESH_PERIOD_IN_MINUTES = 1;
    private static final String NOT_ENOUGH_INFO_MESSAGE = "Not enough information to validate peer. SSLEngine or Socket required.";
    private final Verification verification;
    private final SslSocketAndEnginePeerVerifier socketAndEnginePeerVerifier;
    private volatile X509ExtendedTrustManager delegateManager = null;

    private AdvancedTlsX509TrustManager(Verification verification, SslSocketAndEnginePeerVerifier socketAndEnginePeerVerifier) {
        this.verification = verification;
        this.socketAndEnginePeerVerifier = socketAndEnginePeerVerifier;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new CertificateException(NOT_ENOUGH_INFO_MESSAGE);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkTrusted(chain, authType, null, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkTrusted(chain, authType, engine, null, false);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkTrusted(chain, authType, engine, null, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new CertificateException(NOT_ENOUGH_INFO_MESSAGE);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkTrusted(chain, authType, null, socket, true);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.delegateManager == null) {
            return new X509Certificate[0];
        }
        return this.delegateManager.getAcceptedIssuers();
    }

    public void useSystemDefaultTrustCerts() throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.delegateManager = AdvancedTlsX509TrustManager.createDelegateTrustManager(null);
    }

    private static X509ExtendedTrustManager createDelegateTrustManager(KeyStore keyStore) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        TrustManager[] tms;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        X509ExtendedTrustManager delegateManager = null;
        for (TrustManager tm : tms = tmf.getTrustManagers()) {
            if (!(tm instanceof X509ExtendedTrustManager)) continue;
            delegateManager = (X509ExtendedTrustManager)tm;
            break;
        }
        if (delegateManager == null) {
            throw new CertificateException("Failed to find X509ExtendedTrustManager with default TrustManager algorithm " + TrustManagerFactory.getDefaultAlgorithm());
        }
        return delegateManager;
    }

    private void checkTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine, Socket socket, boolean checkingServer) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("Want certificate verification but got null or empty certificates");
        }
        if (sslEngine == null && socket == null) {
            throw new CertificateException(NOT_ENOUGH_INFO_MESSAGE);
        }
        if (this.verification != Verification.INSECURELY_SKIP_ALL_VERIFICATION) {
            X509ExtendedTrustManager currentDelegateManager = this.delegateManager;
            if (currentDelegateManager == null) {
                throw new CertificateException("No trust roots configured");
            }
            if (checkingServer) {
                String algorithm;
                String string = algorithm = this.verification == Verification.CERTIFICATE_AND_HOST_NAME_VERIFICATION ? "HTTPS" : "";
                if (sslEngine != null) {
                    SSLParameters sslParams = sslEngine.getSSLParameters();
                    sslParams.setEndpointIdentificationAlgorithm(algorithm);
                    sslEngine.setSSLParameters(sslParams);
                    currentDelegateManager.checkServerTrusted(chain, authType, sslEngine);
                } else {
                    if (!(socket instanceof SSLSocket)) {
                        throw new CertificateException("socket is not a type of SSLSocket");
                    }
                    SSLSocket sslSocket = (SSLSocket)socket;
                    SSLParameters sslParams = sslSocket.getSSLParameters();
                    sslParams.setEndpointIdentificationAlgorithm(algorithm);
                    sslSocket.setSSLParameters(sslParams);
                    currentDelegateManager.checkServerTrusted(chain, authType, sslSocket);
                }
            } else if (sslEngine != null) {
                currentDelegateManager.checkClientTrusted(chain, authType, sslEngine);
            } else {
                currentDelegateManager.checkClientTrusted(chain, authType, socket);
            }
        }
        if (this.socketAndEnginePeerVerifier != null) {
            if (sslEngine != null) {
                this.socketAndEnginePeerVerifier.verifyPeerCertificate(chain, authType, sslEngine);
            } else {
                this.socketAndEnginePeerVerifier.verifyPeerCertificate(chain, authType, socket);
            }
        }
    }

    public void updateTrustCredentials(X509Certificate[] trustCerts) throws IOException, GeneralSecurityException {
        Preconditions.checkNotNull(trustCerts, "trustCerts");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        int i = 1;
        for (X509Certificate cert : trustCerts) {
            String alias = Integer.toString(i);
            keyStore.setCertificateEntry(alias, cert);
            ++i;
        }
        this.delegateManager = AdvancedTlsX509TrustManager.createDelegateTrustManager(keyStore);
    }

    public void updateTrustCredentials(File trustCertFile) throws IOException, GeneralSecurityException {
        long updatedTime = this.readAndUpdate(trustCertFile, 0L);
        if (updatedTime == 0L) {
            throw new GeneralSecurityException("Files were unmodified before their initial update. Probably a bug.");
        }
    }

    public Closeable updateTrustCredentials(File trustCertFile, long period, TimeUnit unit, ScheduledExecutorService executor) throws IOException, GeneralSecurityException {
        long updatedTime = this.readAndUpdate(trustCertFile, 0L);
        if (updatedTime == 0L) {
            throw new GeneralSecurityException("Files were unmodified before their initial update. Probably a bug.");
        }
        if (Preconditions.checkNotNull(unit, "unit").toMinutes(period) < 1L) {
            log.log(Level.FINE, "Provided refresh period of {0} {1} is too small. Default value of {2} minute(s) will be used.", new Object[]{period, unit.name(), 1});
            period = 1L;
            unit = TimeUnit.MINUTES;
        }
        ScheduledFuture<?> future = Preconditions.checkNotNull(executor, "executor").scheduleWithFixedDelay(new LoadFilePathExecution(trustCertFile), period, period, unit);
        return () -> future.cancel(false);
    }

    @Deprecated
    @InlineMe(replacement="this.updateTrustCredentials(trustCertFile, period, unit, executor)")
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8024")
    public Closeable updateTrustCredentialsFromFile(File trustCertFile, long period, TimeUnit unit, ScheduledExecutorService executor) throws IOException, GeneralSecurityException {
        return this.updateTrustCredentials(trustCertFile, period, unit, executor);
    }

    @Deprecated
    @InlineMe(replacement="this.updateTrustCredentials(trustCertFile)")
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8024")
    public void updateTrustCredentialsFromFile(File trustCertFile) throws IOException, GeneralSecurityException {
        this.updateTrustCredentials(trustCertFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readAndUpdate(File trustCertFile, long oldTime) throws IOException, GeneralSecurityException {
        long newTime = Preconditions.checkNotNull(trustCertFile, "trustCertFile").lastModified();
        if (newTime == oldTime) {
            return oldTime;
        }
        try (FileInputStream inputStream = new FileInputStream(trustCertFile);){
            X509Certificate[] certificates = CertificateUtils.getX509Certificates(inputStream);
            this.updateTrustCredentials(certificates);
            long l = newTime;
            return l;
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Verification verification = Verification.CERTIFICATE_AND_HOST_NAME_VERIFICATION;
        private SslSocketAndEnginePeerVerifier socketAndEnginePeerVerifier;

        private Builder() {
        }

        public Builder setVerification(Verification verification) {
            this.verification = verification;
            return this;
        }

        public Builder setSslSocketAndEnginePeerVerifier(SslSocketAndEnginePeerVerifier verifier) {
            this.socketAndEnginePeerVerifier = verifier;
            return this;
        }

        public AdvancedTlsX509TrustManager build() throws CertificateException {
            return new AdvancedTlsX509TrustManager(this.verification, this.socketAndEnginePeerVerifier);
        }
    }

    public static interface SslSocketAndEnginePeerVerifier {
        public void verifyPeerCertificate(X509Certificate[] var1, String var2, Socket var3) throws CertificateException;

        public void verifyPeerCertificate(X509Certificate[] var1, String var2, SSLEngine var3) throws CertificateException;
    }

    public static enum Verification {
        CERTIFICATE_AND_HOST_NAME_VERIFICATION,
        CERTIFICATE_ONLY_VERIFICATION,
        INSECURELY_SKIP_ALL_VERIFICATION;

    }

    public static interface Closeable
    extends java.io.Closeable {
        @Override
        public void close();
    }

    private class LoadFilePathExecution
    implements Runnable {
        File file;
        long currentTime;

        public LoadFilePathExecution(File file) {
            this.file = file;
            this.currentTime = 0L;
        }

        @Override
        public void run() {
            try {
                this.currentTime = AdvancedTlsX509TrustManager.this.readAndUpdate(this.file, this.currentTime);
            }
            catch (IOException | GeneralSecurityException e) {
                log.log(Level.SEVERE, String.format("Failed refreshing trust CAs from file. Using previous CAs (file lastModified = %s)", this.file.lastModified()), e);
            }
        }
    }
}

