/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class InstrumentedExecutorService
implements ExecutorService {
    private static final AtomicLong NAME_COUNTER = new AtomicLong();
    private final ExecutorService delegate;
    private final MetricRegistry registry;
    private final String name;
    private final Meter submitted;
    private final Counter running;
    private final Meter completed;
    private final Counter rejected;
    private final Timer idle;
    private final Timer duration;

    public InstrumentedExecutorService(ExecutorService delegate, MetricRegistry registry) {
        this(delegate, registry, "instrumented-delegate-" + NAME_COUNTER.incrementAndGet());
    }

    public InstrumentedExecutorService(ExecutorService delegate, MetricRegistry registry, String name) {
        this.delegate = delegate;
        this.registry = registry;
        this.name = name;
        this.submitted = registry.meter(MetricRegistry.name(name, "submitted"));
        this.running = registry.counter(MetricRegistry.name(name, "running"));
        this.completed = registry.meter(MetricRegistry.name(name, "completed"));
        this.rejected = registry.counter(MetricRegistry.name(name, "rejected"));
        this.idle = registry.timer(MetricRegistry.name(name, "idle"));
        this.duration = registry.timer(MetricRegistry.name(name, "duration"));
        this.registerInternalMetrics();
    }

    private void registerInternalMetrics() {
        if (this.delegate instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)this.delegate;
            this.registry.registerGauge(MetricRegistry.name(this.name, "pool.size"), executor::getPoolSize);
            this.registry.registerGauge(MetricRegistry.name(this.name, "pool.core"), executor::getCorePoolSize);
            this.registry.registerGauge(MetricRegistry.name(this.name, "pool.max"), executor::getMaximumPoolSize);
            BlockingQueue<Runnable> queue = executor.getQueue();
            this.registry.registerGauge(MetricRegistry.name(this.name, "tasks.active"), executor::getActiveCount);
            this.registry.registerGauge(MetricRegistry.name(this.name, "tasks.completed"), executor::getCompletedTaskCount);
            this.registry.registerGauge(MetricRegistry.name(this.name, "tasks.queued"), queue::size);
            this.registry.registerGauge(MetricRegistry.name(this.name, "tasks.capacity"), queue::remainingCapacity);
            RejectedExecutionHandler delegateHandler = executor.getRejectedExecutionHandler();
            executor.setRejectedExecutionHandler(new InstrumentedRejectedExecutionHandler(delegateHandler));
        } else if (this.delegate instanceof ForkJoinPool) {
            ForkJoinPool forkJoinPool = (ForkJoinPool)this.delegate;
            this.registry.registerGauge(MetricRegistry.name(this.name, "tasks.stolen"), forkJoinPool::getStealCount);
            this.registry.registerGauge(MetricRegistry.name(this.name, "tasks.queued"), forkJoinPool::getQueuedTaskCount);
            this.registry.registerGauge(MetricRegistry.name(this.name, "threads.active"), forkJoinPool::getActiveThreadCount);
            this.registry.registerGauge(MetricRegistry.name(this.name, "threads.running"), forkJoinPool::getRunningThreadCount);
        }
    }

    private void removeInternalMetrics() {
        if (this.delegate instanceof ThreadPoolExecutor) {
            this.registry.remove(MetricRegistry.name(this.name, "pool.size"));
            this.registry.remove(MetricRegistry.name(this.name, "pool.core"));
            this.registry.remove(MetricRegistry.name(this.name, "pool.max"));
            this.registry.remove(MetricRegistry.name(this.name, "tasks.active"));
            this.registry.remove(MetricRegistry.name(this.name, "tasks.completed"));
            this.registry.remove(MetricRegistry.name(this.name, "tasks.queued"));
            this.registry.remove(MetricRegistry.name(this.name, "tasks.capacity"));
        } else if (this.delegate instanceof ForkJoinPool) {
            this.registry.remove(MetricRegistry.name(this.name, "tasks.stolen"));
            this.registry.remove(MetricRegistry.name(this.name, "tasks.queued"));
            this.registry.remove(MetricRegistry.name(this.name, "threads.active"));
            this.registry.remove(MetricRegistry.name(this.name, "threads.running"));
        }
    }

    @Override
    public void execute(Runnable runnable) {
        this.submitted.mark();
        this.delegate.execute(new InstrumentedRunnable(runnable));
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        this.submitted.mark();
        return this.delegate.submit(new InstrumentedRunnable(runnable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result) {
        this.submitted.mark();
        return this.delegate.submit(new InstrumentedRunnable(runnable), result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.submitted.mark();
        return this.delegate.submit(new InstrumentedCallable<T>(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.submitted.mark(tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        return this.delegate.invokeAll(instrumented);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.submitted.mark(tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        return this.delegate.invokeAll(instrumented, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        this.submitted.mark(tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        return this.delegate.invokeAny(instrumented);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        this.submitted.mark(tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        return this.delegate.invokeAny(instrumented, timeout, unit);
    }

    private <T> Collection<? extends Callable<T>> instrument(Collection<? extends Callable<T>> tasks) {
        ArrayList<InstrumentedCallable<T>> instrumented = new ArrayList<InstrumentedCallable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            instrumented.add(new InstrumentedCallable<T>(task));
        }
        return instrumented;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
        this.removeInternalMetrics();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> remainingTasks = this.delegate.shutdownNow();
        this.removeInternalMetrics();
        return remainingTasks;
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    private class InstrumentedRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final RejectedExecutionHandler delegateHandler;

        public InstrumentedRejectedExecutionHandler(RejectedExecutionHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            InstrumentedExecutorService.this.rejected.inc();
            this.delegateHandler.rejectedExecution(r, executor);
        }
    }

    private class InstrumentedRunnable
    implements Runnable {
        private final Runnable task;
        private final Timer.Context idleContext;

        InstrumentedRunnable(Runnable task) {
            this.task = task;
            this.idleContext = InstrumentedExecutorService.this.idle.time();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.idleContext.stop();
            InstrumentedExecutorService.this.running.inc();
            try (Timer.Context durationContext = InstrumentedExecutorService.this.duration.time();){
                this.task.run();
            }
            finally {
                InstrumentedExecutorService.this.running.dec();
                InstrumentedExecutorService.this.completed.mark();
            }
        }
    }

    private class InstrumentedCallable<T>
    implements Callable<T> {
        private final Callable<T> callable;
        private final Timer.Context idleContext;

        InstrumentedCallable(Callable<T> callable) {
            this.callable = callable;
            this.idleContext = InstrumentedExecutorService.this.idle.time();
        }

        @Override
        public T call() throws Exception {
            this.idleContext.stop();
            InstrumentedExecutorService.this.running.inc();
            try {
                T t;
                block9: {
                    Timer.Context context = InstrumentedExecutorService.this.duration.time();
                    try {
                        t = this.callable.call();
                        if (context == null) break block9;
                        context.close();
                    }
                    catch (Throwable throwable) {
                        if (context != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                return t;
            }
            finally {
                InstrumentedExecutorService.this.running.dec();
                InstrumentedExecutorService.this.completed.mark();
            }
        }
    }
}

