/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opencensusshim;

import io.opencensus.common.Clock;
import io.opencensus.implcore.common.MillisClock;
import io.opencensus.implcore.trace.config.TraceConfigImpl;
import io.opencensus.trace.TraceComponent;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.config.TraceConfig;
import io.opencensus.trace.config.TraceParams;
import io.opencensus.trace.export.ExportComponent;
import io.opencensus.trace.propagation.PropagationComponent;
import io.opencensus.trace.samplers.Samplers;
import io.opentelemetry.opencensusshim.OpenTelemetryPropagationComponentImpl;
import io.opentelemetry.opencensusshim.OpenTelemetryTracerImpl;
import io.opentelemetry.opencensusshim.ThreadLocalRandomHandler;

public final class OpenTelemetryTraceComponentImpl
extends TraceComponent {
    private final PropagationComponent propagationComponent = new OpenTelemetryPropagationComponentImpl();
    private final ExportComponent noopExportComponent = ExportComponent.newNoopExportComponent();
    private final Clock clock;
    private final TraceConfig traceConfig = OpenTelemetryTraceComponentImpl.makeTraceConfig();
    private final Tracer tracer;

    public OpenTelemetryTraceComponentImpl() {
        this.clock = MillisClock.getInstance();
        ThreadLocalRandomHandler randomHandler = new ThreadLocalRandomHandler();
        this.tracer = new OpenTelemetryTracerImpl(randomHandler, this.traceConfig);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public PropagationComponent getPropagationComponent() {
        return this.propagationComponent;
    }

    public Clock getClock() {
        return this.clock;
    }

    public ExportComponent getExportComponent() {
        return this.noopExportComponent;
    }

    public TraceConfig getTraceConfig() {
        return this.traceConfig;
    }

    private static TraceConfig makeTraceConfig() {
        TraceConfigImpl traceConfig = new TraceConfigImpl();
        traceConfig.updateActiveTraceParams(TraceParams.DEFAULT.toBuilder().setSampler(Samplers.alwaysSample()).build());
        return traceConfig;
    }
}

