/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.cassandra.v4_4;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.dse.driver.internal.core.cql.reactive.DefaultReactiveResultSet;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.session.Session;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.cassandra.v4_4.CassandraRequest;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class TracingCqlSession {
    private final Instrumenter<CassandraRequest, ExecutionInfo> instrumenter;

    TracingCqlSession(Instrumenter<CassandraRequest, ExecutionInfo> instrumenter) {
        this.instrumenter = instrumenter;
    }

    CqlSession wrapSession(CqlSession session) {
        if (session == null) {
            return null;
        }
        ArrayList interfaces = new ArrayList();
        for (Class clazz = session.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
        }
        return (CqlSession)Proxy.newProxyInstance(session.getClass().getClassLoader(), interfaces.toArray(new Class[0]), (proxy, method, args) -> {
            if ("execute".equals(method.getName()) && method.getParameterCount() == 1) {
                if (method.getParameterTypes()[0] == String.class) {
                    String query = (String)args[0];
                    return this.execute(session, query);
                }
                if (method.getParameterTypes()[0] == Statement.class) {
                    Statement statement = (Statement)args[0];
                    return this.execute(session, statement);
                }
            } else if ("executeAsync".equals(method.getName()) && method.getParameterCount() == 1) {
                if (method.getParameterTypes()[0] == String.class) {
                    String query = (String)args[0];
                    return this.executeAsync(session, query);
                }
                if (method.getParameterTypes()[0] == Statement.class) {
                    Statement statement = (Statement)args[0];
                    return this.executeAsync(session, statement);
                }
            } else if ("executeReactive".equals(method.getName()) && method.getParameterCount() == 1) {
                if (method.getParameterTypes()[0] == String.class) {
                    String query = (String)args[0];
                    return this.executeReactive(session, query);
                }
                if (method.getParameterTypes()[0] == Statement.class) {
                    Statement statement = (Statement)args[0];
                    return this.executeReactive(session, statement);
                }
            }
            return method.invoke((Object)session, args);
        });
    }

    private ResultSet execute(CqlSession session, String query) {
        ResultSet resultSet;
        CassandraRequest request = CassandraRequest.create((Session)session, query);
        Context context = this.instrumenter.start(Context.current(), (Object)request);
        try (Scope ignored = context.makeCurrent();){
            resultSet = session.execute(query);
        }
        catch (Throwable exception) {
            this.instrumenter.end(context, (Object)request, (Object)TracingCqlSession.getExecutionInfo(exception), exception);
            throw exception;
        }
        this.instrumenter.end(context, (Object)request, (Object)resultSet.getExecutionInfo(), null);
        return resultSet;
    }

    private ResultSet execute(CqlSession session, Statement<?> statement) {
        ResultSet resultSet;
        String query = TracingCqlSession.getQuery(statement);
        CassandraRequest request = CassandraRequest.create((Session)session, query);
        Context context = this.instrumenter.start(Context.current(), (Object)request);
        try (Scope ignored = context.makeCurrent();){
            resultSet = session.execute(statement);
        }
        catch (Throwable exception) {
            this.instrumenter.end(context, (Object)request, (Object)TracingCqlSession.getExecutionInfo(exception), exception);
            throw exception;
        }
        this.instrumenter.end(context, (Object)request, (Object)resultSet.getExecutionInfo(), null);
        return resultSet;
    }

    private CompletionStage<AsyncResultSet> executeAsync(CqlSession session, Statement<?> statement) {
        String query = TracingCqlSession.getQuery(statement);
        CassandraRequest request = CassandraRequest.create((Session)session, query);
        return this.executeAsync(request, () -> session.executeAsync(statement));
    }

    private CompletionStage<AsyncResultSet> executeAsync(CqlSession session, String query) {
        CassandraRequest request = CassandraRequest.create((Session)session, query);
        return this.executeAsync(request, () -> session.executeAsync(query));
    }

    private CompletionStage<AsyncResultSet> executeAsync(CassandraRequest request, Supplier<CompletionStage<AsyncResultSet>> query) {
        Context parentContext = Context.current();
        Context context = this.instrumenter.start(parentContext, (Object)request);
        try (Scope ignored = context.makeCurrent();){
            CompletionStage<AsyncResultSet> stage = query.get();
            CompletableFuture<AsyncResultSet> completableFuture = TracingCqlSession.wrap(stage.whenComplete((asyncResultSet, throwable) -> this.instrumenter.end(context, (Object)request, (Object)TracingCqlSession.getExecutionInfo(asyncResultSet, throwable), throwable)), parentContext);
            return completableFuture;
        }
    }

    private ReactiveResultSet executeReactive(CqlSession session, String query) {
        return new DefaultReactiveResultSet(() -> this.executeAsync(session, query));
    }

    private ReactiveResultSet executeReactive(CqlSession session, Statement<?> statement) {
        return new DefaultReactiveResultSet(() -> this.executeAsync(session, statement));
    }

    private static <T> CompletableFuture<T> wrap(CompletionStage<T> future, Context context) {
        CompletableFuture result = new CompletableFuture();
        future.whenComplete((value, throwable) -> {
            try (Scope ignored = context.makeCurrent();){
                if (throwable != null) {
                    result.completeExceptionally((Throwable)throwable);
                } else {
                    result.complete(value);
                }
            }
        });
        return result;
    }

    private static String getQuery(Statement<?> statement) {
        String query = null;
        if (statement instanceof SimpleStatement) {
            query = ((SimpleStatement)statement).getQuery();
        } else if (statement instanceof BoundStatement) {
            query = ((BoundStatement)statement).getPreparedStatement().getQuery();
        }
        return query == null ? "" : query;
    }

    private static ExecutionInfo getExecutionInfo(@Nullable AsyncResultSet asyncResultSet, @Nullable Throwable throwable) {
        if (asyncResultSet != null) {
            return asyncResultSet.getExecutionInfo();
        }
        return TracingCqlSession.getExecutionInfo(throwable);
    }

    private static ExecutionInfo getExecutionInfo(@Nullable Throwable throwable) {
        if (throwable instanceof DriverException) {
            return ((DriverException)throwable).getExecutionInfo();
        }
        if (throwable != null && throwable.getCause() instanceof DriverException) {
            return ((DriverException)throwable.getCause()).getExecutionInfo();
        }
        return null;
    }
}

