/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.DataSize;
import io.trino.spi.HostAddress;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.File;
import java.util.List;
import java.util.Set;

@DefunctConfig(value={"kafka.connect-timeout"})
public class KafkaConfig {
    private static final int KAFKA_DEFAULT_PORT = 9092;
    private Set<HostAddress> nodes = ImmutableSet.of();
    private DataSize kafkaBufferSize = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private String defaultSchema = "default";
    private boolean hideInternalColumns = true;
    private int messagesPerSplit = 100000;
    private boolean timestampUpperBoundPushDownEnabled;
    private String tableDescriptionSupplier = "file";
    private List<File> resourceConfigFiles = ImmutableList.of();
    private String internalFieldPrefix = "_";

    @Size(min=1)
    public @Size(min=1) Set<HostAddress> getNodes() {
        return this.nodes;
    }

    @Config(value="kafka.nodes")
    @ConfigDescription(value="Seed nodes for Kafka cluster. At least one must exist")
    public KafkaConfig setNodes(Set<String> nodes) {
        this.nodes = (Set)nodes.stream().map(KafkaConfig::toHostAddress).collect(ImmutableSet.toImmutableSet());
        return this;
    }

    public DataSize getKafkaBufferSize() {
        return this.kafkaBufferSize;
    }

    @Config(value="kafka.buffer-size")
    @ConfigDescription(value="Kafka message consumer buffer size")
    public KafkaConfig setKafkaBufferSize(String kafkaBufferSize) {
        this.kafkaBufferSize = DataSize.valueOf((String)kafkaBufferSize);
        return this;
    }

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="kafka.default-schema")
    @ConfigDescription(value="Schema name to use in the connector")
    public KafkaConfig setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    @NotNull
    public String getTableDescriptionSupplier() {
        return this.tableDescriptionSupplier;
    }

    @Config(value="kafka.table-description-supplier")
    @ConfigDescription(value="The table description supplier to use, default is FILE")
    public KafkaConfig setTableDescriptionSupplier(String tableDescriptionSupplier) {
        this.tableDescriptionSupplier = tableDescriptionSupplier;
        return this;
    }

    public boolean isHideInternalColumns() {
        return this.hideInternalColumns;
    }

    @Config(value="kafka.hide-internal-columns")
    @ConfigDescription(value="Whether internal columns are shown in table metadata or not. Default is no")
    public KafkaConfig setHideInternalColumns(boolean hideInternalColumns) {
        this.hideInternalColumns = hideInternalColumns;
        return this;
    }

    private static HostAddress toHostAddress(String value) {
        return HostAddress.fromString((String)value).withDefaultPort(9092);
    }

    @Min(value=1L)
    public @Min(value=1L) int getMessagesPerSplit() {
        return this.messagesPerSplit;
    }

    @Config(value="kafka.messages-per-split")
    @ConfigDescription(value="Count of Kafka messages to be processed by single Trino Kafka connector split")
    public KafkaConfig setMessagesPerSplit(int messagesPerSplit) {
        this.messagesPerSplit = messagesPerSplit;
        return this;
    }

    public boolean isTimestampUpperBoundPushDownEnabled() {
        return this.timestampUpperBoundPushDownEnabled;
    }

    @Config(value="kafka.timestamp-upper-bound-force-push-down-enabled")
    @ConfigDescription(value="timestamp upper bound force pushing down enabled")
    public KafkaConfig setTimestampUpperBoundPushDownEnabled(boolean timestampUpperBoundPushDownEnabled) {
        this.timestampUpperBoundPushDownEnabled = timestampUpperBoundPushDownEnabled;
        return this;
    }

    public @NotNull List<@FileExists File> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="kafka.config.resources")
    @ConfigDescription(value="Optional config files")
    public KafkaConfig setResourceConfigFiles(List<String> files) {
        this.resourceConfigFiles = (List)files.stream().map(File::new).collect(ImmutableList.toImmutableList());
        return this;
    }

    @NotEmpty
    public String getInternalFieldPrefix() {
        return this.internalFieldPrefix;
    }

    @Config(value="kafka.internal-column-prefix")
    @ConfigDescription(value="Prefix for internal columns")
    public KafkaConfig setInternalFieldPrefix(String internalFieldPrefix) {
        this.internalFieldPrefix = internalFieldPrefix;
        return this;
    }
}

