/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.trino.plugin.kafka.KafkaColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public record KafkaTopicFieldDescription(String name, Type type, String mapping, String comment, String dataFormat, String formatHint, boolean hidden) {
    public KafkaTopicFieldDescription {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        Objects.requireNonNull(type, "type is null");
    }

    KafkaColumnHandle columnHandle(boolean keyCodec) {
        return new KafkaColumnHandle(this.name(), this.type(), this.mapping(), this.dataFormat(), this.formatHint(), keyCodec, this.hidden(), false);
    }

    ColumnMetadata columnMetadata() {
        return ColumnMetadata.builder().setName(this.name()).setType(this.type()).setComment(Optional.ofNullable(this.comment())).setHidden(this.hidden()).build();
    }
}

