/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.plugin.kafka.encoder.RowEncoder;
import io.trino.plugin.kafka.encoder.RowEncoderFactory;
import io.trino.plugin.kafka.encoder.RowEncoderSpec;
import io.trino.spi.connector.ConnectorSession;
import java.util.Map;
import java.util.Objects;

public class DispatchingRowEncoderFactory {
    private final Map<String, RowEncoderFactory> factories;

    @Inject
    public DispatchingRowEncoderFactory(Map<String, RowEncoderFactory> factories) {
        this.factories = ImmutableMap.copyOf(Objects.requireNonNull(factories, "factories is null"));
    }

    public RowEncoder create(ConnectorSession session, RowEncoderSpec rowEncoderSpec) {
        Preconditions.checkArgument((boolean)this.factories.containsKey(rowEncoderSpec.dataFormat()), (String)"unknown data format '%s'", (Object)rowEncoderSpec.dataFormat());
        return this.factories.get(rowEncoderSpec.dataFormat()).create(session, rowEncoderSpec);
    }
}

