/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.avro;

import com.google.common.base.Preconditions;
import io.trino.plugin.kafka.encoder.RowEncoder;
import io.trino.plugin.kafka.encoder.RowEncoderFactory;
import io.trino.plugin.kafka.encoder.RowEncoderSpec;
import io.trino.plugin.kafka.encoder.avro.AvroRowEncoder;
import io.trino.spi.connector.ConnectorSession;
import org.apache.avro.Schema;

public class AvroRowEncoderFactory
implements RowEncoderFactory {
    @Override
    public RowEncoder create(ConnectorSession session, RowEncoderSpec rowEncoderSpec) {
        Preconditions.checkArgument((boolean)rowEncoderSpec.dataSchema().isPresent(), (Object)"dataSchema for Avro format is not present");
        Schema parsedSchema = new Schema.Parser().parse(rowEncoderSpec.dataSchema().get());
        return new AvroRowEncoder(session, rowEncoderSpec.columnHandles(), parsedSchema);
    }
}

