/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.kafka.KafkaTopicDescription;
import io.trino.plugin.kafka.schema.TableDescriptionSupplier;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MapBasedTableDescriptionSupplier
implements TableDescriptionSupplier {
    private final Map<SchemaTableName, KafkaTopicDescription> map;

    public MapBasedTableDescriptionSupplier(Map<SchemaTableName, KafkaTopicDescription> map) {
        this.map = ImmutableMap.copyOf(Objects.requireNonNull(map, "map is null"));
    }

    @Override
    public Set<SchemaTableName> listTables() {
        return this.map.keySet();
    }

    @Override
    public Optional<KafkaTopicDescription> getTopicDescription(ConnectorSession session, SchemaTableName schemaTableName) {
        return Optional.ofNullable(this.map.get(schemaTableName));
    }
}

