/*
 * Decompiled with CFR 0.152.
 */
package io.trino.re2j;

import io.trino.re2j.DFAState;
import io.trino.re2j.DFAStateKey;
import io.trino.re2j.Inst;
import io.trino.re2j.MachineInput;
import io.trino.re2j.Prog;
import io.trino.re2j.RE2;
import io.trino.re2j.SparseSet;
import io.trino.re2j.Utils;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class DFA {
    static final int NO_MATCH = -1;
    static final int FLAG_MATCH = 256;
    static final int FLAG_LAST_WORD = 512;
    static final int FLAG_NEED_SHIFT = 16;
    static final int FLAG_EMPTY_MASK = 255;
    private static final int MARK = -1;
    private static final int START_PARAMS_CACHE_SIZE = 8192;
    private static final int START_PARAMS_CACHE_SHIFT = 12;
    private static final StartParams DEAD_START_PARAMS = new StartParams(DFAState.DEAD_STATE, new boolean[256]);
    private final Prog prog;
    private final Inst[] instructions;
    private final RE2.MatchKind matchKind;
    private final boolean runForward;
    private WorkQueue currentWorkQ;
    private WorkQueue nextWorkQ;
    private final int[] instStack;
    private final StartParams[] startParamsCache = new StartParams[8192];
    private final ConcurrentHashMap<DFAStateKey, DFAState> statesCache;
    private final AtomicInteger availableStates;

    public DFA(Prog prog, RE2.MatchKind matchKind, boolean reversed, ConcurrentHashMap<DFAStateKey, DFAState> statesCache, AtomicInteger availableStates) {
        this.prog = prog;
        this.instructions = prog.getInst();
        this.matchKind = matchKind;
        this.runForward = !reversed;
        this.statesCache = statesCache;
        this.availableStates = availableStates;
        int progSize = prog.numInst();
        int nMarks = 0;
        if (matchKind == RE2.MatchKind.LONGEST_MATCH) {
            nMarks = progSize;
        }
        this.currentWorkQ = new WorkQueue(progSize, nMarks);
        this.nextWorkQ = new WorkQueue(progSize, nMarks);
        int stackSize = 2 * progSize + nMarks;
        this.instStack = new int[stackSize];
    }

    public int search(MachineInput in, int startPos, int endPos, boolean anchored, boolean wantEarliestMatch) {
        StartParams startParams = this.analyzeSearch(in, startPos, endPos, anchored);
        if (startParams.startState.isDead()) {
            return -1;
        }
        return this.searchLoop(in, startPos, endPos, wantEarliestMatch, startParams);
    }

    private DFAState workQueueToCachedState(WorkQueue q, int flag) {
        int[] instIndexes = new int[q.getMaxSize()];
        int nIndexes = 0;
        int neededFlags = 0;
        int size = q.getSize();
        block3: for (int i = 0; i < size; ++i) {
            int instIndex = q.getValueAt(i);
            if (q.isMark(instIndex)) {
                if (nIndexes <= 0 || instIndexes[nIndexes - 1] == -1) continue;
                instIndexes[nIndexes++] = -1;
                continue;
            }
            Inst inst = this.instructions[instIndex];
            switch (inst.op()) {
                case ALT_MATCH: 
                case BYTE: 
                case EMPTY_WIDTH: 
                case MATCH: 
                case ALT: {
                    instIndexes[nIndexes++] = instIndex;
                    if (inst.op() != Inst.Op.EMPTY_WIDTH) continue block3;
                    neededFlags |= inst.arg;
                    continue block3;
                }
            }
        }
        if (nIndexes > 0 && instIndexes[nIndexes - 1] == -1) {
            --nIndexes;
        }
        if (neededFlags == 0) {
            flag &= 0x100;
        }
        if (nIndexes == 0 && flag == 0) {
            return DFAState.DEAD_STATE;
        }
        if (this.matchKind == RE2.MatchKind.LONGEST_MATCH) {
            int ip = 0;
            while (ip < nIndexes) {
                int markp;
                for (markp = ip; markp < nIndexes && instIndexes[markp] != -1; ++markp) {
                }
                Arrays.sort(instIndexes, ip, markp);
                if (markp < nIndexes) {
                    // empty if block
                }
                ip = ++markp;
            }
        }
        return this.getCachedState(instIndexes, nIndexes, flag |= neededFlags << 16);
    }

    private DFAState getCachedState(int[] instIndexes, int nIndexes, int flag) {
        DFAStateKey key = new DFAStateKey(instIndexes, nIndexes, flag);
        DFAState state = this.statesCache.get(key);
        if (state == null) {
            state = new DFAState(instIndexes, nIndexes, flag);
            key = new DFAStateKey(state.getInstIndexes(), nIndexes, flag);
            DFAState previousState = this.statesCache.putIfAbsent(key, state);
            if (previousState != null) {
                return previousState;
            }
            if (this.availableStates.decrementAndGet() < 0) {
                throw new DFATooManyStatesException();
            }
        }
        return state;
    }

    private void stateToWorkQueue(DFAState state, WorkQueue queue) {
        int[] instIndexes;
        queue.clear();
        for (int index : instIndexes = state.getInstIndexes()) {
            if (index == -1) {
                queue.mark();
                continue;
            }
            queue.insertNew(index);
        }
    }

    private void addToQueue(WorkQueue q, int id, int flag) {
        int stackSize = 0;
        this.instStack[stackSize++] = id;
        while (stackSize > 0) {
            if ((id = this.instStack[--stackSize]) == -1) {
                q.mark();
                continue;
            }
            if (q.contains(id)) continue;
            q.insertNew(id);
            Inst inst = this.instructions[id];
            switch (inst.op()) {
                case BYTE: 
                case MATCH: 
                case FAIL: {
                    break;
                }
                case CAPTURE: 
                case NOP: {
                    this.instStack[stackSize++] = inst.out;
                    break;
                }
                case ALT_MATCH: 
                case ALT: {
                    this.instStack[stackSize++] = inst.arg;
                    if (this.currentWorkQ.maxMark > 0 && id == this.prog.startUnanchored && id != this.prog.start) {
                        this.instStack[stackSize++] = -1;
                    }
                    this.instStack[stackSize++] = inst.out;
                    break;
                }
                case EMPTY_WIDTH: {
                    if ((inst.arg & ~flag) != 0) break;
                    this.instStack[stackSize++] = inst.out;
                }
            }
        }
    }

    private void runWorkQueueOnEmptyString(int flag) {
        this.nextWorkQ.clear();
        for (int i = 0; i < this.currentWorkQ.getSize(); ++i) {
            int instIndex = this.currentWorkQ.getValueAt(i);
            if (this.currentWorkQ.isMark(instIndex)) {
                this.addToQueue(this.nextWorkQ, -1, flag);
                continue;
            }
            this.addToQueue(this.nextWorkQ, instIndex, flag);
        }
    }

    private boolean runWorkQueueOnByte(byte b, int flag) {
        this.nextWorkQ.clear();
        boolean isMatch = false;
        block5: for (int i = 0; i < this.currentWorkQ.getSize(); ++i) {
            int instIndex = this.currentWorkQ.getValueAt(i);
            if (this.currentWorkQ.isMark(instIndex)) {
                if (isMatch) {
                    return true;
                }
                this.nextWorkQ.mark();
                continue;
            }
            Inst inst = this.prog.getInst(instIndex);
            switch (inst.op()) {
                case ALT_MATCH: 
                case EMPTY_WIDTH: 
                case ALT: 
                case FAIL: 
                case CAPTURE: 
                case NOP: {
                    continue block5;
                }
                case BYTE: {
                    if (!inst.matchByte(b)) continue block5;
                    this.addToQueue(this.nextWorkQ, inst.out, flag);
                    continue block5;
                }
                case MATCH: {
                    isMatch = true;
                    if (this.matchKind != RE2.MatchKind.FIRST_MATCH) continue block5;
                    return true;
                }
            }
        }
        return isMatch;
    }

    private DFAState runStateOnByte(DFAState state, byte b) {
        boolean isWord;
        int beforeFlag;
        if (state.isDead()) {
            throw new IllegalArgumentException("cannot run byte on DEAD STATE");
        }
        DFAState nextState = state.getNextState(b);
        if (nextState != null) {
            return nextState;
        }
        this.stateToWorkQueue(state, this.currentWorkQ);
        int needFlag = state.getFlag() >> 16;
        int oldBeforeFlag = beforeFlag = state.getFlag() & 0xFF;
        int afterFlag = 0;
        if (b == 10) {
            beforeFlag |= 2;
            afterFlag |= 1;
        }
        if (b == -1) {
            beforeFlag |= 0xA;
        }
        boolean isLastWord = (state.getFlag() & 0x200) != 0;
        boolean bl = isWord = b != -1 && Utils.isWordByte(b);
        beforeFlag = isWord == isLastWord ? (beforeFlag |= 0x20) : (beforeFlag |= 0x10);
        if ((beforeFlag & ~oldBeforeFlag & needFlag) != 0) {
            this.runWorkQueueOnEmptyString(beforeFlag);
            this.switchWorkQueues();
        }
        boolean isMatch = this.runWorkQueueOnByte(b, afterFlag);
        this.switchWorkQueues();
        int flag = afterFlag;
        if (isMatch) {
            flag |= 0x100;
        }
        if (isWord) {
            flag |= 0x200;
        }
        nextState = this.workQueueToCachedState(this.currentWorkQ, flag);
        state.setNextState(b, nextState);
        return nextState;
    }

    private void switchWorkQueues() {
        WorkQueue tmpQueue = this.currentWorkQ;
        this.currentWorkQ = this.nextWorkQ;
        this.nextWorkQ = tmpQueue;
    }

    private StartParams analyzeSearch(MachineInput in, int startPos, int endPos, boolean anchored) {
        if (startPos < 0 || startPos > in.endPos()) {
            return DEAD_START_PARAMS;
        }
        int flags = 0;
        if (this.runForward) {
            if (startPos == 0) {
                flags = 5;
            } else if (in.getByteUnchecked(startPos - 1) == 10) {
                flags = 1;
            } else if (Utils.isWordByte(in.getByteUnchecked(startPos - 1))) {
                flags = 512;
            }
        } else if (endPos == in.endPos()) {
            flags = 5;
        } else if (in.getByteUnchecked(endPos) == 10) {
            flags = 1;
        } else if (Utils.isWordByte(in.getByteUnchecked(endPos))) {
            flags = 512;
        }
        return this.getCachedStartParams(anchored, flags);
    }

    private StartParams getCachedStartParams(boolean anchored, int flags) {
        StartParams startParams;
        int key = this.startParamsKey(anchored, flags);
        if (this.startParamsCache[key] != null) {
            return this.startParamsCache[key];
        }
        this.startParamsCache[key] = startParams = this.computeStartParams(anchored, flags);
        return startParams;
    }

    private int startParamsKey(boolean anchored, int flags) {
        return flags | (anchored ? 1 : 0) << 12;
    }

    private StartParams computeStartParams(boolean anchored, int flags) {
        this.currentWorkQ.clear();
        if (anchored) {
            this.addToQueue(this.currentWorkQ, this.prog.start, flags);
        } else {
            this.addToQueue(this.currentWorkQ, this.prog.startUnanchored, flags);
        }
        DFAState startState = this.workQueueToCachedState(this.currentWorkQ, flags);
        if (startState.isDead()) {
            return DEAD_START_PARAMS;
        }
        boolean[] firstByte = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            DFAState state = this.runStateOnByte(startState, (byte)i);
            if (state == startState || this.runForward && !Utils.isRuneStart((byte)i)) continue;
            firstByte[i] = true;
        }
        return new StartParams(startState, firstByte);
    }

    private int searchLoop(MachineInput in, int startPos, int endPos, boolean wantEarliestMatch, StartParams startParams) {
        int endIndex;
        int currentIndex;
        int lastMatchIndex = -1;
        DFAState currentState = startParams.startState;
        if (this.runForward) {
            currentIndex = startPos;
            endIndex = endPos;
        } else {
            currentIndex = endPos;
            endIndex = startPos;
        }
        while (currentIndex != endIndex && (currentState != startParams.startState || (currentIndex = this.findFirstByte(in, currentIndex, endIndex, startParams.firstByte)) != endIndex)) {
            byte b = this.runForward ? in.getByteUnchecked(currentIndex++) : in.getByteUnchecked(--currentIndex);
            if ((currentState = this.getNextState(currentState, b)).isDead()) {
                return lastMatchIndex;
            }
            if (!currentState.isMatch()) continue;
            lastMatchIndex = this.runForward ? currentIndex - 1 : currentIndex + 1;
            if (!wantEarliestMatch) continue;
            return lastMatchIndex;
        }
        byte lastByte = this.runForward ? (endPos == in.endPos() ? (byte)-1 : (byte)in.getByteUnchecked(endPos)) : (startPos == 0 ? (byte)-1 : (byte)in.getByteUnchecked(startPos - 1));
        currentState = this.getNextState(currentState, lastByte);
        if (currentState.isMatch()) {
            lastMatchIndex = currentIndex;
        }
        return lastMatchIndex;
    }

    private int findFirstByte(MachineInput in, int currentIndex, int endIndex, boolean[] firstByte) {
        if (this.runForward) {
            return this.findFirstByteForward(in, currentIndex, endIndex, firstByte);
        }
        return this.findFirstByteBackward(in, currentIndex, endIndex, firstByte);
    }

    private int findFirstByteForward(MachineInput in, int currentIndex, int endIndex, boolean[] firstByte) {
        for (int i = currentIndex; i < endIndex; ++i) {
            if (!firstByte[in.getByteUnchecked(i) & 0xFF]) continue;
            return i;
        }
        return endIndex;
    }

    private int findFirstByteBackward(MachineInput in, int currentIndex, int endIndex, boolean[] firstByte) {
        for (int i = currentIndex - 1; i >= endIndex; --i) {
            if (!firstByte[in.getByteUnchecked(i) & 0xFF]) continue;
            return i + 1;
        }
        return endIndex;
    }

    private DFAState getNextState(DFAState currentState, byte currentByte) {
        DFAState nextState = currentState.getNextState(currentByte);
        if (nextState == null) {
            nextState = this.runStateOnByte(currentState, currentByte);
        }
        return nextState;
    }

    private static final class StartParams {
        final DFAState startState;
        final boolean[] firstByte;

        StartParams(DFAState startState, boolean[] firstByte) {
            this.startState = startState;
            this.firstByte = firstByte;
        }
    }

    private static class WorkQueue
    extends SparseSet {
        final int normalSlots;
        final int maxMark;
        int nextMark;
        boolean wasLastMark;

        WorkQueue(int normalSlots, int maxMark) {
            super(normalSlots + maxMark);
            this.normalSlots = normalSlots;
            this.maxMark = maxMark;
            this.nextMark = normalSlots;
            this.wasLastMark = false;
        }

        boolean isMark(int i) {
            return i >= this.normalSlots;
        }

        @Override
        void clear() {
            super.clear();
            this.nextMark = this.normalSlots;
        }

        void mark() {
            if (!this.wasLastMark) {
                this.wasLastMark = true;
                this.add(this.nextMark++);
            }
        }

        int getMaxSize() {
            return this.normalSlots + this.maxMark;
        }

        void insertNew(int id) {
            this.wasLastMark = false;
            this.add(id);
        }
    }

    static class DFATooManyStatesException
    extends RuntimeException {
        private DFATooManyStatesException() {
            super("DFA has reached a number of states limit");
        }
    }
}

