/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.TracingDataSource;
import io.trino.plugin.jdbc.credential.CredentialPropertiesProvider;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.DefaultCredentialPropertiesProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class DriverConnectionFactory
implements ConnectionFactory {
    private final Driver driver;
    private final String connectionUrl;
    private final Properties connectionProperties;
    private final CredentialPropertiesProvider credentialPropertiesProvider;
    private final TracingDataSource dataSource;

    public DriverConnectionFactory(Driver driver, String connectionUrl, Properties connectionProperties, CredentialPropertiesProvider credentialPropertiesProvider, OpenTelemetry openTelemetry) {
        this.driver = Objects.requireNonNull(driver, "driver is null");
        this.connectionUrl = Objects.requireNonNull(connectionUrl, "connectionUrl is null");
        this.connectionProperties = new Properties();
        this.connectionProperties.putAll((Map<?, ?>)Objects.requireNonNull(connectionProperties, "connectionProperties is null"));
        this.credentialPropertiesProvider = Objects.requireNonNull(credentialPropertiesProvider, "credentialPropertiesProvider is null");
        this.dataSource = new TracingDataSource(Objects.requireNonNull(openTelemetry, "openTelemetry is null"), driver, connectionUrl);
    }

    @Override
    public Connection openConnection(ConnectorSession session) throws SQLException {
        Properties properties = this.getCredentialProperties(session.getIdentity());
        Connection connection = this.dataSource.getConnection(properties);
        Preconditions.checkState((connection != null ? 1 : 0) != 0, (String)"Driver returned null connection, make sure the connection URL '%s' is valid for the driver %s", (Object)this.connectionUrl, (Object)this.driver);
        return connection;
    }

    private Properties getCredentialProperties(ConnectorIdentity identity) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.connectionProperties);
        properties.putAll(this.credentialPropertiesProvider.getCredentialProperties(identity));
        return properties;
    }

    public static Builder builder(Driver driver, String connectionUrl, CredentialProvider credentialProvider) {
        return new Builder(driver, connectionUrl, credentialProvider);
    }

    public static class Builder {
        private final Driver driver;
        private final String connectionUrl;
        private Properties connectionProperties = new Properties();
        private CredentialPropertiesProvider credentialPropertiesProvider;
        private OpenTelemetry openTelemetry = OpenTelemetry.noop();

        private Builder(Driver driver, String connectionUrl, CredentialProvider credentialProvider) {
            this.driver = Objects.requireNonNull(driver, "driver is null");
            this.connectionUrl = Objects.requireNonNull(connectionUrl, "connectionUrl is null");
            this.credentialPropertiesProvider = new DefaultCredentialPropertiesProvider(Objects.requireNonNull(credentialProvider, "credentialProvider is null"));
        }

        public Builder setConnectionProperties(Properties connectionProperties) {
            this.connectionProperties = connectionProperties;
            return this;
        }

        public Builder setCredentialPropertiesProvider(CredentialPropertiesProvider credentialPropertiesProvider) {
            this.credentialPropertiesProvider = credentialPropertiesProvider;
            return this;
        }

        public Builder setOpenTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }

        public DriverConnectionFactory build() {
            return new DriverConnectionFactory(this.driver, this.connectionUrl, this.connectionProperties, this.credentialPropertiesProvider, this.openTelemetry);
        }
    }
}

