/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import io.trino.plugin.google.sheets.SheetNotFoundException;
import io.trino.plugin.google.sheets.SheetsNamedTableHandle;
import io.trino.plugin.google.sheets.SheetsSheetTableHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.NotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;

public sealed interface SheetsConnectorTableHandle
extends ConnectorTableHandle
permits SheetsNamedTableHandle, SheetsSheetTableHandle {
    public static NotFoundException tableNotFound(SheetsConnectorTableHandle tableHandle) {
        if (tableHandle instanceof SheetsNamedTableHandle) {
            SheetsNamedTableHandle sheetsNamedTableHandle = (SheetsNamedTableHandle)tableHandle;
            return new TableNotFoundException(new SchemaTableName(sheetsNamedTableHandle.schemaName(), sheetsNamedTableHandle.tableName()));
        }
        if (tableHandle instanceof SheetsSheetTableHandle) {
            SheetsSheetTableHandle sheetsSheetTableHandle = (SheetsSheetTableHandle)tableHandle;
            return new SheetNotFoundException(sheetsSheetTableHandle.getSheetExpression());
        }
        throw new IllegalStateException("Found unexpected table handle type " + String.valueOf(tableHandle));
    }
}

