/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.posix.internal.jnr;

import jnr.ffi.Platform;
import jnr.ffi.provider.FFIProvider;
import net.openhft.posix.PosixAPI;
import net.openhft.posix.internal.UnsafeMemory;
import net.openhft.posix.internal.jnr.Kernel32JNRInterface;
import net.openhft.posix.internal.jnr.LibraryUtil;
import net.openhft.posix.internal.jnr.WinJNRPosixInterface;

public final class WinJNRPosixAPI
implements PosixAPI {
    static final jnr.ffi.Runtime RUNTIME = FFIProvider.getSystemProvider().getRuntime();
    static final Platform NATIVE_PLATFORM = Platform.getNativePlatform();
    static final String STANDARD_C_LIBRARY_NAME = NATIVE_PLATFORM.getStandardCLibraryName();
    private final WinJNRPosixInterface jnr = LibraryUtil.load(WinJNRPosixInterface.class, STANDARD_C_LIBRARY_NAME);
    private final Kernel32JNRInterface kernel32 = LibraryUtil.load(Kernel32JNRInterface.class, "Kernel32");

    @Override
    public int open(CharSequence path, int flags, int perm) {
        return this.jnr._open(path, flags, perm);
    }

    @Override
    public long lseek(int fd, long offset, int whence) {
        return this.jnr._lseeki64(fd, offset, whence);
    }

    @Override
    public int lockf(int fd, int cmd, long len) {
        return -1;
    }

    @Override
    public long read(int fd, long dst, long len) {
        return this.jnr._read(fd, dst, len);
    }

    @Override
    public long write(int fd, long src, long len) {
        return this.jnr._write(fd, src, len);
    }

    @Override
    public int close(int fd) {
        return this.jnr._close(fd);
    }

    @Override
    public int getpid() {
        return this.jnr._getpid();
    }

    @Override
    public int gettid() {
        return this.kernel32.GetCurrentThreadId();
    }

    @Override
    public int madvise(long addr, long length, int advise) {
        return 0;
    }

    @Override
    public int msync(long address, long length, int flags) {
        return 0;
    }

    @Override
    public int fallocate(int fd, int mode, long offset, long length) {
        return 0;
    }

    @Override
    public long malloc(long size) {
        return UnsafeMemory.UNSAFE.allocateMemory(size);
    }

    @Override
    public void free(long ptr) {
        UnsafeMemory.UNSAFE.freeMemory(ptr);
    }

    @Override
    public long clock_gettime() {
        return System.currentTimeMillis() * 1000000L;
    }

    @Override
    public int get_nprocs() {
        return this.get_nprocs_conf();
    }

    @Override
    public int get_nprocs_conf() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int ftruncate(int fd, long offset) {
        return 0;
    }

    @Override
    public long mmap(long addr, long length, int prot, int flags, int fd, long offset) {
        return 0L;
    }

    @Override
    public int munmap(long addr, long length) {
        return 0;
    }

    @Override
    public int gettimeofday(long timeval) {
        long now = System.currentTimeMillis();
        UnsafeMemory.UNSAFE.putLong(timeval, now / 1000L);
        UnsafeMemory.UNSAFE.putLong(timeval + 8L, now % 1000L * 1000L);
        return 0;
    }

    @Override
    public int sched_setaffinity(int pid, int cpusetsize, long mask) {
        return -1;
    }

    @Override
    public int sched_getaffinity(int pid, int cpusetsize, long mask) {
        return -1;
    }

    @Override
    public int lastError() {
        return RUNTIME.getLastError();
    }

    @Override
    public long clock_gettime(int clockId) throws IllegalArgumentException {
        return System.currentTimeMillis() * 1000000L;
    }

    @Override
    public String strerror(int errno) {
        return this.jnr.strerror(errno);
    }
}

