/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.units.Duration;
import io.trino.plugin.resourcegroups.AbstractResourceConfigurationManager;
import io.trino.plugin.resourcegroups.FileResourceGroupConfig;
import io.trino.plugin.resourcegroups.ManagerSpec;
import io.trino.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.trino.plugin.resourcegroups.ResourceGroupSelector;
import io.trino.plugin.resourcegroups.ResourceGroupSpec;
import io.trino.spi.memory.ClusterMemoryPoolManager;
import io.trino.spi.resourcegroups.ResourceGroup;
import io.trino.spi.resourcegroups.SelectionContext;
import io.trino.spi.resourcegroups.SelectionCriteria;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FileResourceGroupConfigurationManager
extends AbstractResourceConfigurationManager {
    private static final JsonCodec<ManagerSpec> CODEC = new JsonCodecFactory(() -> new ObjectMapperProvider().get().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).jsonCodec(ManagerSpec.class);
    private final Optional<LifeCycleManager> lifeCycleManager;
    private final List<ResourceGroupSpec> rootGroups;
    private final List<ResourceGroupSelector> selectors;
    private final Optional<Duration> cpuQuotaPeriod;

    @Inject
    public FileResourceGroupConfigurationManager(LifeCycleManager lifeCycleManager, ClusterMemoryPoolManager memoryPoolManager, FileResourceGroupConfig config) {
        this(Optional.of(lifeCycleManager), memoryPoolManager, FileResourceGroupConfigurationManager.parseManagerSpec(config));
    }

    @VisibleForTesting
    FileResourceGroupConfigurationManager(ClusterMemoryPoolManager memoryPoolManager, FileResourceGroupConfig config) {
        this(Optional.empty(), memoryPoolManager, FileResourceGroupConfigurationManager.parseManagerSpec(config));
    }

    @VisibleForTesting
    FileResourceGroupConfigurationManager(ClusterMemoryPoolManager memoryPoolManager, ManagerSpec managerSpec) {
        this(Optional.empty(), memoryPoolManager, managerSpec);
    }

    private FileResourceGroupConfigurationManager(Optional<LifeCycleManager> lifeCycleManager, ClusterMemoryPoolManager memoryPoolManager, ManagerSpec managerSpec) {
        super(memoryPoolManager);
        Objects.requireNonNull(managerSpec, "managerSpec is null");
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.rootGroups = ImmutableList.copyOf(managerSpec.getRootGroups());
        this.cpuQuotaPeriod = managerSpec.getCpuQuotaPeriod();
        this.validateRootGroups(managerSpec);
        this.selectors = this.buildSelectors(managerSpec);
    }

    @VisibleForTesting
    static ManagerSpec parseManagerSpec(FileResourceGroupConfig config) {
        ManagerSpec managerSpec;
        try (InputStream stream = Files.newInputStream(Paths.get(config.getConfigFile(), new String[0]), new OpenOption[0]);){
            managerSpec = (ManagerSpec)CODEC.fromJson(stream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (IllegalArgumentException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnrecognizedPropertyException) {
                UnrecognizedPropertyException ex = (UnrecognizedPropertyException)cause;
                String message = String.format("Unknown property at line %s:%s: %s", ex.getLocation().getLineNr(), ex.getLocation().getColumnNr(), ex.getPropertyName());
                throw new IllegalArgumentException(message, e);
            }
            if (cause instanceof JsonMappingException) {
                if (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                throw new IllegalArgumentException(cause.getMessage(), e);
            }
            throw e;
        }
        return managerSpec;
    }

    @Override
    protected Optional<Duration> getCpuQuotaPeriod() {
        return this.cpuQuotaPeriod;
    }

    @Override
    protected List<ResourceGroupSpec> getRootGroups() {
        return this.rootGroups;
    }

    public void configure(ResourceGroup group, SelectionContext<ResourceGroupIdTemplate> context) {
        this.configureGroup(group, this.getMatchingSpec(group, context));
    }

    public Optional<SelectionContext<ResourceGroupIdTemplate>> match(SelectionCriteria criteria) {
        return this.selectors.stream().map(s -> s.match(criteria)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public void shutdown() {
        this.lifeCycleManager.ifPresent(LifeCycleManager::stop);
    }
}

