/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.Query;
import com.linkedin.coral.$internal.io.trino.sql.tree.Relation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Lateral
extends Relation {
    private final Query query;

    public Lateral(Query query) {
        this(Optional.empty(), query);
    }

    public Lateral(NodeLocation location, Query query) {
        this(Optional.of(location), query);
    }

    private Lateral(Optional<NodeLocation> location, Query query) {
        super(location);
        this.query = Objects.requireNonNull(query, "query is null");
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLateral(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of(this.query);
    }

    @Override
    public String toString() {
        return "LATERAL(" + this.query + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.query);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Lateral other = (Lateral)obj;
        return Objects.equals(this.query, other.query);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return Lateral.sameClass(this, other);
    }
}

