/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class DecimalTypeInfo
extends PrimitiveTypeInfo {
    private static final long serialVersionUID = 1L;
    private int precision;
    private int scale;

    public DecimalTypeInfo() {
        super("decimal");
    }

    public DecimalTypeInfo(int precision, int scale) {
        super("decimal");
        HiveDecimalUtils.validateParameter(precision, scale);
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public String getTypeName() {
        return this.getQualifiedName();
    }

    @Override
    public void setTypeName(String typeName) {
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DecimalTypeInfo dti = (DecimalTypeInfo)other;
        return this.precision() == dti.precision() && this.scale() == dti.scale();
    }

    @Override
    public int hashCode() {
        return 31 * (17 + this.precision) + this.scale;
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public String getQualifiedName() {
        return DecimalTypeInfo.getQualifiedName(this.precision, this.scale);
    }

    public static String getQualifiedName(int precision, int scale) {
        StringBuilder sb = new StringBuilder("decimal");
        sb.append("(");
        sb.append(precision);
        sb.append(",");
        sb.append(scale);
        sb.append(")");
        return sb.toString();
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    @Override
    public boolean accept(TypeInfo other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DecimalTypeInfo dti = (DecimalTypeInfo)other;
        return this.precision() - this.scale() >= dti.precision() - dti.scale();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }
}

