/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.openjdk.jol.info;

import com.linkedin.coral.$internal.org.openjdk.jol.info.FieldData;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ClassData {
    private final String name;
    private final List<FieldData> fields;
    private final List<String> classNames;
    private final String arrayKlass;
    private final String arrayComponentKlass;
    private final int length;
    private final boolean isArray;

    public static ClassData parseInstance(Object o) {
        Class<?> k = o.getClass();
        if (k.isArray()) {
            if (k == byte[].class) {
                return ClassData.parseArray(k, ((byte[])o).length);
            }
            if (k == boolean[].class) {
                return ClassData.parseArray(k, ((boolean[])o).length);
            }
            if (k == short[].class) {
                return ClassData.parseArray(k, ((short[])o).length);
            }
            if (k == char[].class) {
                return ClassData.parseArray(k, ((char[])o).length);
            }
            if (k == int[].class) {
                return ClassData.parseArray(k, ((int[])o).length);
            }
            if (k == float[].class) {
                return ClassData.parseArray(k, ((float[])o).length);
            }
            if (k == double[].class) {
                return ClassData.parseArray(k, ((double[])o).length);
            }
            if (k == long[].class) {
                return ClassData.parseArray(k, ((long[])o).length);
            }
            return ClassData.parseArray(k, ((Object[])o).length);
        }
        return ClassData.parseClass(k);
    }

    public static ClassData parseArray(Class arrayClass, int length) {
        return new ClassData(arrayClass.getName(), arrayClass.getComponentType().getName(), length);
    }

    public static ClassData parseClass(Class klass) {
        ClassData cd2 = new ClassData(klass.getCanonicalName());
        do {
            for (Field f : klass.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                cd2.addField(FieldData.parse(f));
            }
            cd2.addSuperClass(klass.getSimpleName());
        } while ((klass = klass.getSuperclass()) != null);
        return cd2;
    }

    public ClassData(String name) {
        this.name = name;
        this.fields = new ArrayList<FieldData>();
        this.classNames = new ArrayList<String>();
        this.length = -1;
        this.arrayKlass = null;
        this.arrayComponentKlass = null;
        this.isArray = false;
    }

    public ClassData(String arrayKlass, String componentKlass, int length) {
        this.name = arrayKlass;
        this.arrayKlass = arrayKlass;
        this.arrayComponentKlass = componentKlass;
        this.fields = null;
        this.classNames = null;
        this.length = length;
        this.isArray = true;
    }

    public void addSuperClass(String superClass) {
        this.classNames.add(0, superClass);
    }

    public void addField(FieldData fieldData) {
        this.fields.add(fieldData);
    }

    public Collection<FieldData> fields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Collection<FieldData> fieldsFor(String klass) {
        ArrayList<FieldData> r = new ArrayList<FieldData>();
        for (FieldData f : this.fields) {
            if (!f.hostClass().equals(klass)) continue;
            r.add(f);
        }
        return r;
    }

    public List<String> classHierarchy() {
        return Collections.unmodifiableList(this.classNames);
    }

    public String name() {
        return this.name;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String arrayClass() {
        if (!this.isArray) {
            throw new IllegalStateException("Asking array class for non-array ClassData");
        }
        return this.arrayKlass;
    }

    public String arrayComponentType() {
        if (!this.isArray) {
            throw new IllegalStateException("Asking array component type for non-array ClassData");
        }
        return this.arrayComponentKlass;
    }

    public int arrayLength() {
        if (!this.isArray) {
            throw new IllegalStateException("Asking array length for non-array ClassData");
        }
        return this.length;
    }

    public void merge(ClassData superClassData) {
        this.fields.addAll(superClassData.fields);
        this.classNames.addAll(0, superClassData.classNames);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassData classData = (ClassData)o;
        if (this.isArray != classData.isArray) {
            return false;
        }
        if (this.length != classData.length) {
            return false;
        }
        if (this.arrayComponentKlass != null ? !this.arrayComponentKlass.equals(classData.arrayComponentKlass) : classData.arrayComponentKlass != null) {
            return false;
        }
        if (this.arrayKlass != null ? !this.arrayKlass.equals(classData.arrayKlass) : classData.arrayKlass != null) {
            return false;
        }
        if (this.classNames != null ? !this.classNames.equals(classData.classNames) : classData.classNames != null) {
            return false;
        }
        return !(this.fields != null ? !this.fields.equals(classData.fields) : classData.fields != null);
    }

    public int hashCode() {
        int result = this.fields != null ? this.fields.hashCode() : 0;
        result = 31 * result + (this.classNames != null ? this.classNames.hashCode() : 0);
        result = 31 * result + (this.arrayKlass != null ? this.arrayKlass.hashCode() : 0);
        result = 31 * result + (this.arrayComponentKlass != null ? this.arrayComponentKlass.hashCode() : 0);
        result = 31 * result + this.length;
        result = 31 * result + (this.isArray ? 1 : 0);
        return result;
    }
}

