/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.Memory;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.Family;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.SketchesArgumentException;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.CompactDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DirectCompactDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DirectUpdateDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesAuxiliary;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesByteArrayImpl;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesMergeImpl;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesPmfCdfImpl;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesSketchBuilder;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesUtil;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.HeapUpdateDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.Util;
import java.util.Random;

public abstract class DoublesSketch {
    static final int DOUBLES_SER_VER = 3;
    static final int MAX_PRELONGS = Family.QUANTILES.getMaxPreLongs();
    static final int MIN_K = 2;
    final int k_;
    public static final Random rand = new Random();

    DoublesSketch(int k) {
        Util.checkK(k);
        this.k_ = k;
    }

    public static final DoublesSketchBuilder builder() {
        return new DoublesSketchBuilder();
    }

    public static DoublesSketch heapify(Memory srcMem) {
        if (Util.checkIsCompactMemory(srcMem)) {
            return CompactDoublesSketch.heapify(srcMem);
        }
        return UpdateDoublesSketch.heapify(srcMem);
    }

    public static DoublesSketch wrap(Memory srcMem) {
        if (Util.checkIsCompactMemory(srcMem)) {
            return DirectCompactDoublesSketch.wrapInstance(srcMem);
        }
        return DirectUpdateDoublesSketch.wrapInstance(srcMem);
    }

    public double getQuantile(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new SketchesArgumentException("Fraction cannot be less than zero or greater than 1.0");
        }
        if (fraction == 0.0) {
            return this.getMinValue();
        }
        if (fraction == 1.0) {
            return this.getMaxValue();
        }
        DoublesAuxiliary aux = this.constructAuxiliary();
        return aux.getQuantile(fraction);
    }

    public double[] getQuantiles(double[] fractions) {
        Util.validateFractions(fractions);
        DoublesAuxiliary aux = null;
        double[] answers = new double[fractions.length];
        for (int i = 0; i < fractions.length; ++i) {
            double fraction = fractions[i];
            if (fraction == 0.0) {
                answers[i] = this.getMinValue();
                continue;
            }
            if (fraction == 1.0) {
                answers[i] = this.getMaxValue();
                continue;
            }
            if (aux == null) {
                aux = this.constructAuxiliary();
            }
            answers[i] = aux.getQuantile(fraction);
        }
        return answers;
    }

    public double[] getQuantiles(int evenlySpaced) {
        return this.getQuantiles(DoublesSketch.getEvenlySpaced(evenlySpaced));
    }

    public double[] getPMF(double[] splitPoints) {
        return DoublesPmfCdfImpl.getPMFOrCDF(this, splitPoints, false);
    }

    public double[] getCDF(double[] splitPoints) {
        return DoublesPmfCdfImpl.getPMFOrCDF(this, splitPoints, true);
    }

    public int getK() {
        return this.k_;
    }

    public abstract double getMinValue();

    public abstract double getMaxValue();

    public abstract long getN();

    public double getNormalizedRankError() {
        return DoublesSketch.getNormalizedRankError(this.getK());
    }

    public static double getNormalizedRankError(int k) {
        return Util.EpsilonFromK.getAdjustedEpsilon(k);
    }

    public boolean isEmpty() {
        return this.getN() == 0L;
    }

    public abstract boolean isDirect();

    public boolean isEstimationMode() {
        return this.getN() >= 2L * (long)this.k_;
    }

    public byte[] toByteArray() {
        if (this.isCompact()) {
            return this.toByteArray(true);
        }
        return this.toByteArray(false);
    }

    public byte[] toByteArray(boolean compact) {
        return DoublesByteArrayImpl.toByteArray(this, compact, compact);
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean sketchSummary, boolean dataDetail) {
        return DoublesUtil.toString(sketchSummary, dataDetail, this);
    }

    public DoublesSketch downSample(DoublesSketch srcSketch, int smallerK, Memory dstMem) {
        return this.downSampleInternal(srcSketch, smallerK, dstMem);
    }

    public int getRetainedItems() {
        return Util.computeRetainedItems(this.getK(), this.getN());
    }

    public int getCompactStorageBytes() {
        return DoublesSketch.getCompactStorageBytes(this.getK(), this.getN());
    }

    public static int getCompactStorageBytes(int k, long n) {
        if (n == 0L) {
            return 8;
        }
        int metaPreLongs = MAX_PRELONGS + 2;
        return metaPreLongs + Util.computeRetainedItems(k, n) << 3;
    }

    public int getStorageBytes() {
        if (this.isCompact()) {
            return this.getCompactStorageBytes();
        }
        return this.getUpdatableStorageBytes();
    }

    public int getUpdatableStorageBytes() {
        return DoublesSketch.getUpdatableStorageBytes(this.getK(), this.getN());
    }

    public static int getUpdatableStorageBytes(int k, long n) {
        if (n == 0L) {
            return 8;
        }
        int metaPre = MAX_PRELONGS + 2;
        int totLevels = Util.computeNumLevelsNeeded(k, n);
        if (n <= (long)k) {
            int ceil = Math.max(com.linkedin.coral.calcite.$internal.com.yahoo.sketches.Util.ceilingPowerOf2((int)n), 4);
            return metaPre + ceil << 3;
        }
        return metaPre + (2 + totLevels) * k << 3;
    }

    public void putMemory(Memory dstMem) {
        this.putMemory(dstMem, true);
    }

    private byte[] toSortedByteArray(boolean compact) {
        return DoublesByteArrayImpl.toByteArray(this, true, compact);
    }

    public void putMemory(Memory dstMem, boolean compact) {
        byte[] byteArr = this.toSortedByteArray(compact);
        int arrLen = byteArr.length;
        long memCap = dstMem.getCapacity();
        if (memCap < (long)arrLen) {
            throw new SketchesArgumentException("Destination Memory not large enough: " + memCap + " < " + arrLen);
        }
        dstMem.putByteArray(0L, byteArr, 0, arrLen);
    }

    UpdateDoublesSketch downSampleInternal(DoublesSketch srcSketch, int smallerK, Memory dstMem) {
        UpdateDoublesSketch newSketch = dstMem == null ? HeapUpdateDoublesSketch.newInstance(smallerK) : DirectUpdateDoublesSketch.newInstance(smallerK, dstMem);
        DoublesMergeImpl.downSamplingMergeInto(srcSketch, newSketch);
        return newSketch;
    }

    static double[] getEvenlySpaced(int evenlySpaced) {
        double frac;
        int n = evenlySpaced;
        if (n <= 0) {
            throw new SketchesArgumentException("EvenlySpaced must be > zero.");
        }
        double[] fractions = new double[n];
        fractions[0] = frac = 0.0;
        for (int i = 1; i < n; ++i) {
            fractions[i] = frac = (double)i / (double)(n - 1);
        }
        if (n > 1) {
            fractions[n - 1] = 1.0;
        }
        return fractions;
    }

    DoublesAuxiliary constructAuxiliary() {
        return new DoublesAuxiliary(this);
    }

    abstract boolean isCompact();

    abstract int getBaseBufferCount();

    abstract long getBitPattern();

    abstract int getCombinedBufferItemCapacity();

    abstract double[] getCombinedBuffer();

    abstract Memory getMemory();
}

