/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore.TableType;
import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.common.HiveTable;
import com.linkedin.coral.common.HiveViewTable;
import com.linkedin.coral.hive.metastore.api.Table;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;

public class HiveDbSchema
implements Schema {
    public static final String DEFAULT_DB = "default";
    private final HiveMetastoreClient msc;
    private final String dbName;

    HiveDbSchema(@Nonnull HiveMetastoreClient msc, @Nonnull String dbName) {
        Preconditions.checkNotNull((Object)msc);
        Preconditions.checkNotNull((Object)dbName);
        this.msc = msc;
        this.dbName = dbName;
    }

    @Override
    public org.apache.calcite.schema.Table getTable(String name) {
        Table table = this.msc.getTable(this.dbName, name);
        if (table == null) {
            return null;
        }
        TableType tableType = Enum.valueOf(TableType.class, table.getTableType());
        switch (tableType) {
            case VIRTUAL_VIEW: {
                return new HiveViewTable(table, (List<String>)ImmutableList.of((Object)"hive", (Object)this.dbName));
            }
        }
        return new HiveTable(table);
    }

    @Override
    public Set<String> getTableNames() {
        return ImmutableSet.copyOf(this.msc.getAllTables(this.dbName));
    }

    @Override
    public RelProtoDataType getType(String s2) {
        return null;
    }

    @Override
    public Set<String> getTypeNames() {
        return null;
    }

    @Override
    public Collection<Function> getFunctions(String name) {
        return ImmutableList.of();
    }

    @Override
    public Set<String> getFunctionNames() {
        return ImmutableSet.of();
    }

    @Override
    public Schema getSubSchema(String name) {
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return ImmutableSet.of();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return null;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Schema snapshot(SchemaVersion schemaVersion) {
        return this;
    }
}

