/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.transformers.SqlCallTransformer;
import com.linkedin.coral.hive.hive2rel.functions.VersionedSqlUserDefinedFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;

public class HiveUDFTransformer
extends SqlCallTransformer {
    @Override
    protected boolean condition(SqlCall sqlCall) {
        SqlOperator operator = sqlCall.getOperator();
        String operatorName = operator.getName();
        return operator instanceof VersionedSqlUserDefinedFunction && operatorName.contains(".") && !operatorName.equals(".");
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        SqlOperator operator = sqlCall.getOperator();
        String trinoFunctionName = ((VersionedSqlUserDefinedFunction)operator).getShortFunctionName();
        return HiveUDFTransformer.createSqlOperator(trinoFunctionName, operator.getReturnTypeInference()).createCall(new SqlNodeList(sqlCall.getOperandList(), SqlParserPos.ZERO));
    }
}

