/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;

public class SqlRegexpReplaceFunction
extends SqlFunction {
    public SqlRegexpReplaceFunction() {
        super("REGEXP_REPLACE", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.TO_NULLABLE), null, null, SqlFunctionCategory.STRING);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(3, 6);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int i;
        int operandCount = callBinding.getOperandCount();
        for (i = 0; i < 3; ++i) {
            if (OperandTypes.STRING.checkSingleOperandType(callBinding, callBinding.operand(i), 0, throwOnFailure)) continue;
            return false;
        }
        for (i = 3; i < operandCount; ++i) {
            if (i == 3 && !OperandTypes.INTEGER.checkSingleOperandType(callBinding, callBinding.operand(i), 0, throwOnFailure)) {
                return false;
            }
            if (i == 4 && !OperandTypes.INTEGER.checkSingleOperandType(callBinding, callBinding.operand(i), 0, throwOnFailure)) {
                return false;
            }
            if (i != 5 || OperandTypes.STRING.checkSingleOperandType(callBinding, callBinding.operand(i), 0, throwOnFailure)) continue;
            return false;
        }
        return true;
    }
}

