/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class UnicodeUtil {
    private UnicodeUtil() {
    }

    public static boolean isCharHighSurrogate(char ch) {
        return (ch & 0xFC00) == 55296;
    }

    public static CharSequence truncateString(CharSequence input, int length) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"Truncate length should be positive");
        StringBuilder sb = new StringBuilder(input);
        int numUniCodeCharacters = sb.codePointCount(0, sb.length());
        if (length >= numUniCodeCharacters) {
            return input;
        }
        int offsetByCodePoint = sb.offsetByCodePoints(0, length);
        return input.subSequence(0, offsetByCodePoint);
    }

    public static Literal<CharSequence> truncateStringMin(Literal<CharSequence> input, int length) {
        CharSequence truncatedInput = UnicodeUtil.truncateString(input.value(), length);
        return Literal.of(truncatedInput);
    }

    public static Literal<CharSequence> truncateStringMax(Literal<CharSequence> input, int length) {
        CharSequence inputCharSeq = input.value();
        StringBuilder truncatedStringBuilder = new StringBuilder(UnicodeUtil.truncateString(inputCharSeq, length));
        if (inputCharSeq.length() == truncatedStringBuilder.length()) {
            return input;
        }
        for (int i = length - 1; i >= 0; --i) {
            int offsetByCodePoint = truncatedStringBuilder.offsetByCodePoints(0, i);
            int nextCodePoint = UnicodeUtil.incrementCodePoint(truncatedStringBuilder.codePointAt(offsetByCodePoint));
            if (nextCodePoint == 0) continue;
            truncatedStringBuilder.setLength(offsetByCodePoint);
            truncatedStringBuilder.appendCodePoint(nextCodePoint);
            return Literal.of(truncatedStringBuilder.toString());
        }
        return null;
    }

    private static int incrementCodePoint(int codePoint) {
        Preconditions.checkArgument((codePoint < 55296 || codePoint > 57343 ? 1 : 0) != 0, (String)"invalid code point: %s", (int)codePoint);
        if (codePoint == 55295) {
            return 57344;
        }
        if (codePoint == 0x10FFFF) {
            return 0;
        }
        return codePoint + 1;
    }
}

