/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.api.internal.TemporaryBuffers;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.extension.trace.propagation.B3PropagatorInjector;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class B3PropagatorInjectorSingleHeader
implements B3PropagatorInjector {
    private static final int SAMPLED_FLAG_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getLength();
    private static final int COMBINED_HEADER_DELIMITER_SIZE = 1;
    private static final int SPAN_ID_OFFSET = TRACE_ID_HEX_SIZE + 1;
    private static final int SAMPLED_FLAG_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int COMBINED_HEADER_SIZE = SAMPLED_FLAG_OFFSET + 1;
    private static final Collection<String> FIELDS = Collections.singletonList("b3");

    B3PropagatorInjectorSingleHeader() {
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context == null) {
            return;
        }
        if (setter == null) {
            return;
        }
        SpanContext spanContext = Span.fromContext((Context)context).getSpanContext();
        if (!spanContext.isValid()) {
            return;
        }
        char[] chars = TemporaryBuffers.chars((int)COMBINED_HEADER_SIZE);
        String traceId = spanContext.getTraceId();
        traceId.getChars(0, traceId.length(), chars, 0);
        chars[B3PropagatorInjectorSingleHeader.SPAN_ID_OFFSET - 1] = 45;
        String spanId = spanContext.getSpanId();
        spanId.getChars(0, SpanId.getLength(), chars, SPAN_ID_OFFSET);
        chars[B3PropagatorInjectorSingleHeader.SAMPLED_FLAG_OFFSET - 1] = 45;
        chars[B3PropagatorInjectorSingleHeader.SAMPLED_FLAG_OFFSET] = Boolean.TRUE.equals(context.get(B3Propagator.DEBUG_CONTEXT_KEY)) ? 100 : (spanContext.isSampled() ? 49 : 48);
        setter.set(carrier, "b3", new String(chars, 0, COMBINED_HEADER_SIZE));
    }

    @Override
    public Collection<String> fields() {
        return FIELDS;
    }

    public String toString() {
        return "B3PropagatorInjectorSingleHeader";
    }
}

