/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.exemplar;

import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.context.Context;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.common.Clock;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.exemplar.FixedSizeExemplarReservoir;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;
import java.util.List;

class HistogramExemplarReservoir
extends FixedSizeExemplarReservoir<DoubleExemplarData> {
    HistogramExemplarReservoir(Clock clock, List<Double> boundaries) {
        super(clock, boundaries.size() + 1, new HistogramCellSelector(boundaries), ReservoirCell::getAndResetDouble);
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        super.offerDoubleMeasurement(value, attributes, context);
    }

    static class HistogramCellSelector
    implements ReservoirCellSelector {
        private final double[] boundaries;

        private HistogramCellSelector(List<Double> boundaries) {
            this.boundaries = ExplicitBucketHistogramUtils.createBoundaryArray(boundaries);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, long value, Attributes attributes, Context context) {
            return this.reservoirCellIndexFor(cells, (double)value, attributes, context);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, double value, Attributes attributes, Context context) {
            return ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value);
        }

        @Override
        public void reset() {
        }
    }
}

