/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.rest.RestStatus;

public class RoutingMissingException
extends ElasticsearchException {
    private final String type;
    private final String id;

    public RoutingMissingException(String index, String type, String id) {
        super("routing is required for [" + index + "]/[" + type + "]/[" + id + "]", new Object[0]);
        Objects.requireNonNull(index, "index must not be null");
        Objects.requireNonNull(type, "type must not be null");
        Objects.requireNonNull(id, "id must not be null");
        this.setIndex(index);
        this.type = type;
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    public RoutingMissingException(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.id = in.readString();
    }

    @Override
    protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
        super.writeTo(out, nestedExceptionsWriter);
        out.writeString(this.type);
        out.writeString(this.id);
    }
}

