/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.clickhouse.expression;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.clickhouse.ClickHouseClient;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;

public class RewriteStringIn
implements ConnectorExpressionRule<Call, ParameterizedExpression> {
    private static final Capture<Variable> VALUE = Capture.newCapture();
    private static final Capture<List<ConnectorExpression>> EXPRESSIONS = Capture.newCapture();
    private static final Pattern<Call> PATTERN = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().equalTo((Object)StandardFunctions.IN_PREDICATE_FUNCTION_NAME)).with(ConnectorExpressionPatterns.type().equalTo((Object)BooleanType.BOOLEAN)).with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)2)).with(ConnectorExpressionPatterns.argument((int)0).matching(ConnectorExpressionPatterns.variable().with(ConnectorExpressionPatterns.type().matching(type -> type instanceof CharType || type instanceof VarcharType)).matching((variable, context) -> ClickHouseClient.supportsPushdown(variable, (ConnectorExpressionRule.RewriteContext<ParameterizedExpression>)context)).capturedAs(VALUE))).with(ConnectorExpressionPatterns.argument((int)1).matching(ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().equalTo((Object)StandardFunctions.ARRAY_CONSTRUCTOR_FUNCTION_NAME)).matching(call -> call.getArguments().stream().allMatch(argument -> argument instanceof Constant)).matching((call, context) -> call.getArguments().size() <= JdbcMetadataSessionProperties.getDomainCompactionThreshold((ConnectorSession)context.getSession())).with(ConnectorExpressionPatterns.arguments().capturedAs(EXPRESSIONS))));

    public Pattern<Call> getPattern() {
        return PATTERN;
    }

    public Optional<ParameterizedExpression> rewrite(Call call, Captures captures, ConnectorExpressionRule.RewriteContext<ParameterizedExpression> context) {
        Optional value = context.defaultRewrite((ConnectorExpression)captures.get(VALUE));
        if (value.isEmpty()) {
            return Optional.empty();
        }
        List expressions = (List)captures.get(EXPRESSIONS);
        ImmutableList.Builder parameters = ImmutableList.builder();
        parameters.addAll((Iterable)((ParameterizedExpression)value.get()).parameters());
        ImmutableList.Builder rewrittenValues = ImmutableList.builderWithExpectedSize((int)expressions.size());
        for (ConnectorExpression expression : expressions) {
            Optional rewritten = context.defaultRewrite(expression);
            if (rewritten.isEmpty()) {
                return Optional.empty();
            }
            rewrittenValues.add((Object)((ParameterizedExpression)rewritten.get()).expression());
            parameters.addAll((Iterable)((ParameterizedExpression)rewritten.get()).parameters());
        }
        ImmutableList values = rewrittenValues.build();
        Verify.verify((!values.isEmpty() ? 1 : 0) != 0, (String)"Empty values", (Object[])new Object[0]);
        return Optional.of(new ParameterizedExpression(String.format("(%s) IN (%s)", ((ParameterizedExpression)value.get()).expression(), Joiner.on((String)", ").join((Iterable)values)), (List)parameters.build()));
    }
}

