/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.file;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import io.trino.plugin.kafka.schema.AbstractContentSchemaProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;

public class FileReadContentSchemaProvider
extends AbstractContentSchemaProvider {
    @Override
    protected Optional<String> readSchema(Optional<String> dataSchemaLocation, Optional<String> subject) {
        Optional<String> optional;
        block9: {
            if (dataSchemaLocation.isEmpty()) {
                return Optional.empty();
            }
            Preconditions.checkState((boolean)subject.isEmpty(), (Object)"Unexpected parameter: subject");
            InputStream inputStream = FileReadContentSchemaProvider.openSchemaLocation(dataSchemaLocation.get());
            try {
                optional = Optional.of(CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Could not parse the Avro schema at: " + String.valueOf(dataSchemaLocation), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return optional;
    }

    private static InputStream openSchemaLocation(String dataSchemaLocation) throws IOException {
        if (FileReadContentSchemaProvider.isURL(dataSchemaLocation.trim().toLowerCase(Locale.ENGLISH))) {
            try {
                return URI.create(dataSchemaLocation).toURL().openStream();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new FileInputStream(dataSchemaLocation);
    }

    private static boolean isURL(String location) {
        try {
            URI.create(location).toURL();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

