/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.trino.plugin.kafka.KafkaSecurityConfig;
import io.trino.plugin.kafka.security.SslSecurityModule;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class KafkaSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindSecurityModule(SecurityProtocol.SSL, new SslSecurityModule());
    }

    private void bindSecurityModule(SecurityProtocol securityProtocol, Module module) {
        this.install(ConditionalModule.conditionalModule(KafkaSecurityConfig.class, config -> config.getSecurityProtocol().isPresent() && config.getSecurityProtocol().get().equals((Object)securityProtocol), (Module)module));
    }
}

